/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.CancellationReason;
import software.amazon.awssdk.services.dynamodb.model.CancellationReasonListCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactionCanceledException
extends DynamoDbException
implements ToCopyableBuilder<Builder, TransactionCanceledException> {
    private static final SdkField<List<CancellationReason>> CANCELLATION_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CancellationReasons").getter(TransactionCanceledException.getter(TransactionCanceledException::cancellationReasons)).setter(TransactionCanceledException.setter(Builder::cancellationReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancellationReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CancellationReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLATION_REASONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CancellationReason> cancellationReasons;

    private TransactionCanceledException(BuilderImpl builder) {
        super(builder);
        this.cancellationReasons = builder.cancellationReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasCancellationReasons() {
        return this.cancellationReasons != null && !(this.cancellationReasons instanceof SdkAutoConstructList);
    }

    public List<CancellationReason> cancellationReasons() {
        return this.cancellationReasons;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactionCanceledException, T> g) {
        return obj -> g.apply((TransactionCanceledException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbException.BuilderImpl
    implements Builder {
        private List<CancellationReason> cancellationReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionCanceledException model) {
            super(model);
            this.cancellationReasons(model.cancellationReasons);
        }

        public final List<CancellationReason.Builder> getCancellationReasons() {
            List<CancellationReason.Builder> result = CancellationReasonListCopier.copyToBuilder(this.cancellationReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCancellationReasons(Collection<CancellationReason.BuilderImpl> cancellationReasons) {
            this.cancellationReasons = CancellationReasonListCopier.copyFromBuilder(cancellationReasons);
        }

        @Override
        public final Builder cancellationReasons(Collection<CancellationReason> cancellationReasons) {
            this.cancellationReasons = CancellationReasonListCopier.copy(cancellationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancellationReasons(CancellationReason ... cancellationReasons) {
            this.cancellationReasons(Arrays.asList(cancellationReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancellationReasons(Consumer<CancellationReason.Builder> ... cancellationReasons) {
            this.cancellationReasons(Stream.of(cancellationReasons).map(c -> (CancellationReason)((CancellationReason.Builder)CancellationReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public TransactionCanceledException build() {
            return new TransactionCanceledException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransactionCanceledException>,
    DynamoDbException.Builder {
        public Builder cancellationReasons(Collection<CancellationReason> var1);

        public Builder cancellationReasons(CancellationReason ... var1);

        public Builder cancellationReasons(Consumer<CancellationReason.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

