/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a replica to be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReplicationGroupMemberAction implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateReplicationGroupMemberAction.Builder, UpdateReplicationGroupMemberAction> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(UpdateReplicationGroupMemberAction::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSMasterKeyId").getter(getter(UpdateReplicationGroupMemberAction::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()).build();

    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField
            .<ProvisionedThroughputOverride> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedThroughputOverride")
            .getter(getter(UpdateReplicationGroupMemberAction::provisionedThroughputOverride))
            .setter(setter(Builder::provisionedThroughputOverride))
            .constructor(ProvisionedThroughputOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride")
                    .build()).build();

    private static final SdkField<List<ReplicaGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<ReplicaGlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(UpdateReplicationGroupMemberAction::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaGlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaGlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_CLASS_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableClassOverride").getter(getter(UpdateReplicationGroupMemberAction::tableClassOverrideAsString))
            .setter(setter(Builder::tableClassOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClassOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD,
            TABLE_CLASS_OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String kmsMasterKeyId;

    private final ProvisionedThroughputOverride provisionedThroughputOverride;

    private final List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes;

    private final String tableClassOverride;

    private UpdateReplicationGroupMemberAction(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.tableClassOverride = builder.tableClassOverride;
    }

    /**
     * <p>
     * The Region where the replica exists.
     * </p>
     * 
     * @return The Region where the replica exists.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID, Amazon
     * Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is
     * different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.
     * </p>
     * 
     * @return The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID,
     *         Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if
     *         the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.
     */
    public final String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * <p>
     * Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
     * settings.
     * </p>
     * 
     * @return Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
     *         settings.
     */
    public final ProvisionedThroughputOverride provisionedThroughputOverride() {
        return provisionedThroughputOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replica-specific global secondary index settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexes} method.
     * </p>
     * 
     * @return Replica-specific global secondary index settings.
     */
    public final List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * Replica-specific table class. If not specified, uses the source table's table class.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tableClassOverride} will return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #tableClassOverrideAsString}.
     * </p>
     * 
     * @return Replica-specific table class. If not specified, uses the source table's table class.
     * @see TableClass
     */
    public final TableClass tableClassOverride() {
        return TableClass.fromValue(tableClassOverride);
    }

    /**
     * <p>
     * Replica-specific table class. If not specified, uses the source table's table class.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tableClassOverride} will return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #tableClassOverrideAsString}.
     * </p>
     * 
     * @return Replica-specific table class. If not specified, uses the source table's table class.
     * @see TableClass
     */
    public final String tableClassOverrideAsString() {
        return tableClassOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableClassOverrideAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationGroupMemberAction)) {
            return false;
        }
        UpdateReplicationGroupMemberAction other = (UpdateReplicationGroupMemberAction) obj;
        return Objects.equals(regionName(), other.regionName()) && Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId())
                && Objects.equals(provisionedThroughputOverride(), other.provisionedThroughputOverride())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(tableClassOverrideAsString(), other.tableClassOverrideAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReplicationGroupMemberAction").add("RegionName", regionName())
                .add("KMSMasterKeyId", kmsMasterKeyId()).add("ProvisionedThroughputOverride", provisionedThroughputOverride())
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null)
                .add("TableClassOverride", tableClassOverrideAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "KMSMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "ProvisionedThroughputOverride":
            return Optional.ofNullable(clazz.cast(provisionedThroughputOverride()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "TableClassOverride":
            return Optional.ofNullable(clazz.cast(tableClassOverrideAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationGroupMemberAction, T> g) {
        return obj -> g.apply((UpdateReplicationGroupMemberAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateReplicationGroupMemberAction> {
        /**
         * <p>
         * The Region where the replica exists.
         * </p>
         * 
         * @param regionName
         *        The Region where the replica exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID, Amazon
         * Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is
         * different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID,
         *        Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter
         *        if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
         * settings.
         * </p>
         * 
         * @param provisionedThroughputOverride
         *        Replica-specific provisioned throughput. If not specified, uses the source table's provisioned
         *        throughput settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride);

        /**
         * <p>
         * Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
         * settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughputOverride.Builder}
         * avoiding the need to create one manually via {@link ProvisionedThroughputOverride#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughputOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedThroughputOverride(ProvisionedThroughputOverride)}
         * .
         * 
         * @param provisionedThroughputOverride
         *        a consumer that will call methods on {@link ProvisionedThroughputOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughputOverride(ProvisionedThroughputOverride)
         */
        default Builder provisionedThroughputOverride(
                Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return provisionedThroughputOverride(ProvisionedThroughputOverride.builder()
                    .applyMutation(provisionedThroughputOverride).build());
        }

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndex>.Builder} avoiding the need to create one manually via {@link List
         * <ReplicaGlobalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaGlobalSecondaryIndex>.Builder#build()} is called
         * immediately and its result is passed to {@link #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List<ReplicaGlobalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific table class. If not specified, uses the source table's table class.
         * </p>
         * 
         * @param tableClassOverride
         *        Replica-specific table class. If not specified, uses the source table's table class.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClassOverride(String tableClassOverride);

        /**
         * <p>
         * Replica-specific table class. If not specified, uses the source table's table class.
         * </p>
         * 
         * @param tableClassOverride
         *        Replica-specific table class. If not specified, uses the source table's table class.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClassOverride(TableClass tableClassOverride);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String kmsMasterKeyId;

        private ProvisionedThroughputOverride provisionedThroughputOverride;

        private List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private String tableClassOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationGroupMemberAction model) {
            regionName(model.regionName);
            kmsMasterKeyId(model.kmsMasterKeyId);
            provisionedThroughputOverride(model.provisionedThroughputOverride);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            tableClassOverride(model.tableClassOverride);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return provisionedThroughputOverride != null ? provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build()
                    : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<ReplicaGlobalSecondaryIndex.Builder> result = ReplicaGlobalSecondaryIndexListCopier
                    .copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> ReplicaGlobalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTableClassOverride() {
            return tableClassOverride;
        }

        public final void setTableClassOverride(String tableClassOverride) {
            this.tableClassOverride = tableClassOverride;
        }

        @Override
        public final Builder tableClassOverride(String tableClassOverride) {
            this.tableClassOverride = tableClassOverride;
            return this;
        }

        @Override
        public final Builder tableClassOverride(TableClass tableClassOverride) {
            this.tableClassOverride(tableClassOverride == null ? null : tableClassOverride.toString());
            return this;
        }

        @Override
        public UpdateReplicationGroupMemberAction build() {
            return new UpdateReplicationGroupMemberAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
