/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.PreparedStatementParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterizedStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterizedStatement> {
    private static final SdkField<String> STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statement").getter(ParameterizedStatement.getter(ParameterizedStatement::statement)).setter(ParameterizedStatement.setter(Builder::statement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()}).build();
    private static final SdkField<List<AttributeValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(ParameterizedStatement.getter(ParameterizedStatement::parameters)).setter(ParameterizedStatement.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String statement;
    private final List<AttributeValue> parameters;

    private ParameterizedStatement(BuilderImpl builder) {
        this.statement = builder.statement;
        this.parameters = builder.parameters;
    }

    public final String statement() {
        return this.statement;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<AttributeValue> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statement());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedStatement)) {
            return false;
        }
        ParameterizedStatement other = (ParameterizedStatement)obj;
        return Objects.equals(this.statement(), other.statement()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterizedStatement").add("Statement", (Object)this.statement()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statement": {
                return Optional.ofNullable(clazz.cast(this.statement()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterizedStatement, T> g) {
        return obj -> g.apply((ParameterizedStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String statement;
        private List<AttributeValue> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterizedStatement model) {
            this.statement(model.statement);
            this.parameters(model.parameters);
        }

        public final String getStatement() {
            return this.statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        @Transient
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final List<AttributeValue.Builder> getParameters() {
            List<AttributeValue.Builder> result = PreparedStatementParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<AttributeValue.BuilderImpl> parameters) {
            this.parameters = PreparedStatementParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Collection<AttributeValue> parameters) {
            this.parameters = PreparedStatementParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(AttributeValue ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(Consumer<AttributeValue.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ParameterizedStatement build() {
            return new ParameterizedStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterizedStatement> {
        public Builder statement(String var1);

        public Builder parameters(Collection<AttributeValue> var1);

        public Builder parameters(AttributeValue ... var1);

        public Builder parameters(Consumer<AttributeValue.Builder> ... var1);
    }
}

