/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DestinationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisDataStreamDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisDataStreamDestination> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(KinesisDataStreamDestination.getter(KinesisDataStreamDestination::streamArn)).setter(KinesisDataStreamDestination.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationStatus").getter(KinesisDataStreamDestination.getter(KinesisDataStreamDestination::destinationStatusAsString)).setter(KinesisDataStreamDestination.setter(Builder::destinationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()}).build();
    private static final SdkField<String> DESTINATION_STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationStatusDescription").getter(KinesisDataStreamDestination.getter(KinesisDataStreamDestination::destinationStatusDescription)).setter(KinesisDataStreamDestination.setter(Builder::destinationStatusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatusDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, DESTINATION_STATUS_FIELD, DESTINATION_STATUS_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamArn;
    private final String destinationStatus;
    private final String destinationStatusDescription;

    private KinesisDataStreamDestination(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
        this.destinationStatusDescription = builder.destinationStatusDescription;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(this.destinationStatus);
    }

    public final String destinationStatusAsString() {
        return this.destinationStatus;
    }

    public final String destinationStatusDescription() {
        return this.destinationStatusDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStatusDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisDataStreamDestination)) {
            return false;
        }
        KinesisDataStreamDestination other = (KinesisDataStreamDestination)obj;
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.destinationStatusAsString(), other.destinationStatusAsString()) && Objects.equals(this.destinationStatusDescription(), other.destinationStatusDescription());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisDataStreamDestination").add("StreamArn", (Object)this.streamArn()).add("DestinationStatus", (Object)this.destinationStatusAsString()).add("DestinationStatusDescription", (Object)this.destinationStatusDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "DestinationStatus": {
                return Optional.ofNullable(clazz.cast(this.destinationStatusAsString()));
            }
            case "DestinationStatusDescription": {
                return Optional.ofNullable(clazz.cast(this.destinationStatusDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisDataStreamDestination, T> g) {
        return obj -> g.apply((KinesisDataStreamDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private String destinationStatus;
        private String destinationStatusDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisDataStreamDestination model) {
            this.streamArn(model.streamArn);
            this.destinationStatus(model.destinationStatus);
            this.destinationStatusDescription(model.destinationStatusDescription);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        @Transient
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDestinationStatus() {
            return this.destinationStatus;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        @Override
        @Transient
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        public final String getDestinationStatusDescription() {
            return this.destinationStatusDescription;
        }

        public final void setDestinationStatusDescription(String destinationStatusDescription) {
            this.destinationStatusDescription = destinationStatusDescription;
        }

        @Override
        @Transient
        public final Builder destinationStatusDescription(String destinationStatusDescription) {
            this.destinationStatusDescription = destinationStatusDescription;
            return this;
        }

        public KinesisDataStreamDestination build() {
            return new KinesisDataStreamDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisDataStreamDestination> {
        public Builder streamArn(String var1);

        public Builder destinationStatus(String var1);

        public Builder destinationStatus(DestinationStatus var1);

        public Builder destinationStatusDescription(String var1);
    }
}

