/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalSecondaryIndexAutoScalingUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalSecondaryIndexAutoScalingUpdate> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(GlobalSecondaryIndexAutoScalingUpdate.getter(GlobalSecondaryIndexAutoScalingUpdate::indexName)).setter(GlobalSecondaryIndexAutoScalingUpdate.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<AutoScalingSettingsUpdate> PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedWriteCapacityAutoScalingUpdate").getter(GlobalSecondaryIndexAutoScalingUpdate.getter(GlobalSecondaryIndexAutoScalingUpdate::provisionedWriteCapacityAutoScalingUpdate)).setter(GlobalSecondaryIndexAutoScalingUpdate.setter(Builder::provisionedWriteCapacityAutoScalingUpdate)).constructor(AutoScalingSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedWriteCapacityAutoScalingUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate;

    private GlobalSecondaryIndexAutoScalingUpdate(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedWriteCapacityAutoScalingUpdate = builder.provisionedWriteCapacityAutoScalingUpdate;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate() {
        return this.provisionedWriteCapacityAutoScalingUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedWriteCapacityAutoScalingUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexAutoScalingUpdate)) {
            return false;
        }
        GlobalSecondaryIndexAutoScalingUpdate other = (GlobalSecondaryIndexAutoScalingUpdate)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.provisionedWriteCapacityAutoScalingUpdate(), other.provisionedWriteCapacityAutoScalingUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalSecondaryIndexAutoScalingUpdate").add("IndexName", (Object)this.indexName()).add("ProvisionedWriteCapacityAutoScalingUpdate", (Object)this.provisionedWriteCapacityAutoScalingUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ProvisionedWriteCapacityAutoScalingUpdate": {
                return Optional.ofNullable(clazz.cast(this.provisionedWriteCapacityAutoScalingUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalSecondaryIndexAutoScalingUpdate, T> g) {
        return obj -> g.apply((GlobalSecondaryIndexAutoScalingUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexAutoScalingUpdate model) {
            this.indexName(model.indexName);
            this.provisionedWriteCapacityAutoScalingUpdate(model.provisionedWriteCapacityAutoScalingUpdate);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final AutoScalingSettingsUpdate.Builder getProvisionedWriteCapacityAutoScalingUpdate() {
            return this.provisionedWriteCapacityAutoScalingUpdate != null ? this.provisionedWriteCapacityAutoScalingUpdate.toBuilder() : null;
        }

        @Override
        public final Builder provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate) {
            this.provisionedWriteCapacityAutoScalingUpdate = provisionedWriteCapacityAutoScalingUpdate;
            return this;
        }

        public final void setProvisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate.BuilderImpl provisionedWriteCapacityAutoScalingUpdate) {
            this.provisionedWriteCapacityAutoScalingUpdate = provisionedWriteCapacityAutoScalingUpdate != null ? provisionedWriteCapacityAutoScalingUpdate.build() : null;
        }

        public GlobalSecondaryIndexAutoScalingUpdate build() {
            return new GlobalSecondaryIndexAutoScalingUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalSecondaryIndexAutoScalingUpdate> {
        public Builder indexName(String var1);

        public Builder provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate var1);

        default public Builder provisionedWriteCapacityAutoScalingUpdate(Consumer<AutoScalingSettingsUpdate.Builder> provisionedWriteCapacityAutoScalingUpdate) {
            return this.provisionedWriteCapacityAutoScalingUpdate((AutoScalingSettingsUpdate)((AutoScalingSettingsUpdate.Builder)AutoScalingSettingsUpdate.builder().applyMutation(provisionedWriteCapacityAutoScalingUpdate)).build());
        }
    }
}

