/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableReplicaAutoScalingRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateTableReplicaAutoScalingRequest.Builder, UpdateTableReplicaAutoScalingRequest> {
    private static final SdkField<List<GlobalSecondaryIndexAutoScalingUpdate>> GLOBAL_SECONDARY_INDEX_UPDATES_FIELD = SdkField
            .<List<GlobalSecondaryIndexAutoScalingUpdate>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexUpdates")
            .getter(getter(UpdateTableReplicaAutoScalingRequest::globalSecondaryIndexUpdates))
            .setter(setter(Builder::globalSecondaryIndexUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexUpdates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndexAutoScalingUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndexAutoScalingUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateTableReplicaAutoScalingRequest::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<AutoScalingSettingsUpdate> PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_UPDATE_FIELD = SdkField
            .<AutoScalingSettingsUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedWriteCapacityAutoScalingUpdate")
            .getter(getter(UpdateTableReplicaAutoScalingRequest::provisionedWriteCapacityAutoScalingUpdate))
            .setter(setter(Builder::provisionedWriteCapacityAutoScalingUpdate))
            .constructor(AutoScalingSettingsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ProvisionedWriteCapacityAutoScalingUpdate").build()).build();

    private static final SdkField<List<ReplicaAutoScalingUpdate>> REPLICA_UPDATES_FIELD = SdkField
            .<List<ReplicaAutoScalingUpdate>> builder(MarshallingType.LIST)
            .memberName("ReplicaUpdates")
            .getter(getter(UpdateTableReplicaAutoScalingRequest::replicaUpdates))
            .setter(setter(Builder::replicaUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaAutoScalingUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaAutoScalingUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_SECONDARY_INDEX_UPDATES_FIELD, TABLE_NAME_FIELD, PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_UPDATE_FIELD,
            REPLICA_UPDATES_FIELD));

    private final List<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates;

    private final String tableName;

    private final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate;

    private final List<ReplicaAutoScalingUpdate> replicaUpdates;

    private UpdateTableReplicaAutoScalingRequest(BuilderImpl builder) {
        super(builder);
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.tableName = builder.tableName;
        this.provisionedWriteCapacityAutoScalingUpdate = builder.provisionedWriteCapacityAutoScalingUpdate;
        this.replicaUpdates = builder.replicaUpdates;
    }

    /**
     * Returns true if the GlobalSecondaryIndexUpdates property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasGlobalSecondaryIndexUpdates() {
        return globalSecondaryIndexUpdates != null && !(globalSecondaryIndexUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the auto scaling settings of the global secondary indexes of the replica to be updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalSecondaryIndexUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents the auto scaling settings of the global secondary indexes of the replica to be updated.
     */
    public final List<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates() {
        return globalSecondaryIndexUpdates;
    }

    /**
     * <p>
     * The name of the global table to be updated.
     * </p>
     * 
     * @return The name of the global table to be updated.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * Returns the value of the ProvisionedWriteCapacityAutoScalingUpdate property for this object.
     * 
     * @return The value of the ProvisionedWriteCapacityAutoScalingUpdate property for this object.
     */
    public final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate() {
        return provisionedWriteCapacityAutoScalingUpdate;
    }

    /**
     * Returns true if the ReplicaUpdates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReplicaUpdates() {
        return replicaUpdates != null && !(replicaUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the auto scaling settings of replicas of the table that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicaUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents the auto scaling settings of replicas of the table that will be modified.
     */
    public final List<ReplicaAutoScalingUpdate> replicaUpdates() {
        return replicaUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexUpdates() ? globalSecondaryIndexUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedWriteCapacityAutoScalingUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicaUpdates() ? replicaUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableReplicaAutoScalingRequest)) {
            return false;
        }
        UpdateTableReplicaAutoScalingRequest other = (UpdateTableReplicaAutoScalingRequest) obj;
        return hasGlobalSecondaryIndexUpdates() == other.hasGlobalSecondaryIndexUpdates()
                && Objects.equals(globalSecondaryIndexUpdates(), other.globalSecondaryIndexUpdates())
                && Objects.equals(tableName(), other.tableName())
                && Objects.equals(provisionedWriteCapacityAutoScalingUpdate(), other.provisionedWriteCapacityAutoScalingUpdate())
                && hasReplicaUpdates() == other.hasReplicaUpdates() && Objects.equals(replicaUpdates(), other.replicaUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableReplicaAutoScalingRequest")
                .add("GlobalSecondaryIndexUpdates", hasGlobalSecondaryIndexUpdates() ? globalSecondaryIndexUpdates() : null)
                .add("TableName", tableName())
                .add("ProvisionedWriteCapacityAutoScalingUpdate", provisionedWriteCapacityAutoScalingUpdate())
                .add("ReplicaUpdates", hasReplicaUpdates() ? replicaUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalSecondaryIndexUpdates":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexUpdates()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "ProvisionedWriteCapacityAutoScalingUpdate":
            return Optional.ofNullable(clazz.cast(provisionedWriteCapacityAutoScalingUpdate()));
        case "ReplicaUpdates":
            return Optional.ofNullable(clazz.cast(replicaUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableReplicaAutoScalingRequest, T> g) {
        return obj -> g.apply((UpdateTableReplicaAutoScalingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTableReplicaAutoScalingRequest> {
        /**
         * <p>
         * Represents the auto scaling settings of the global secondary indexes of the replica to be updated.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        Represents the auto scaling settings of the global secondary indexes of the replica to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates);

        /**
         * <p>
         * Represents the auto scaling settings of the global secondary indexes of the replica to be updated.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        Represents the auto scaling settings of the global secondary indexes of the replica to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexAutoScalingUpdate... globalSecondaryIndexUpdates);

        /**
         * <p>
         * Represents the auto scaling settings of the global secondary indexes of the replica to be updated.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <GlobalSecondaryIndexAutoScalingUpdate>.Builder} avoiding the need to create one manually via {@link List
         * <GlobalSecondaryIndexAutoScalingUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalSecondaryIndexAutoScalingUpdate>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #globalSecondaryIndexUpdates(List<GlobalSecondaryIndexAutoScalingUpdate>)}.
         * 
         * @param globalSecondaryIndexUpdates
         *        a consumer that will call methods on {@link List<GlobalSecondaryIndexAutoScalingUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexUpdates(List<GlobalSecondaryIndexAutoScalingUpdate>)
         */
        Builder globalSecondaryIndexUpdates(
                Consumer<GlobalSecondaryIndexAutoScalingUpdate.Builder>... globalSecondaryIndexUpdates);

        /**
         * <p>
         * The name of the global table to be updated.
         * </p>
         * 
         * @param tableName
         *        The name of the global table to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * Sets the value of the ProvisionedWriteCapacityAutoScalingUpdate property for this object.
         *
         * @param provisionedWriteCapacityAutoScalingUpdate
         *        The new value for the ProvisionedWriteCapacityAutoScalingUpdate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate);

        /**
         * Sets the value of the ProvisionedWriteCapacityAutoScalingUpdate property for this object.
         *
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsUpdate.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param provisionedWriteCapacityAutoScalingUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate)
         */
        default Builder provisionedWriteCapacityAutoScalingUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> provisionedWriteCapacityAutoScalingUpdate) {
            return provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(provisionedWriteCapacityAutoScalingUpdate).build());
        }

        /**
         * <p>
         * Represents the auto scaling settings of replicas of the table that will be modified.
         * </p>
         * 
         * @param replicaUpdates
         *        Represents the auto scaling settings of replicas of the table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaUpdates(Collection<ReplicaAutoScalingUpdate> replicaUpdates);

        /**
         * <p>
         * Represents the auto scaling settings of replicas of the table that will be modified.
         * </p>
         * 
         * @param replicaUpdates
         *        Represents the auto scaling settings of replicas of the table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaUpdates(ReplicaAutoScalingUpdate... replicaUpdates);

        /**
         * <p>
         * Represents the auto scaling settings of replicas of the table that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaAutoScalingUpdate>.Builder} avoiding
         * the need to create one manually via {@link List<ReplicaAutoScalingUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaAutoScalingUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaUpdates(List<ReplicaAutoScalingUpdate>)}.
         * 
         * @param replicaUpdates
         *        a consumer that will call methods on {@link List<ReplicaAutoScalingUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaUpdates(List<ReplicaAutoScalingUpdate>)
         */
        Builder replicaUpdates(Consumer<ReplicaAutoScalingUpdate.Builder>... replicaUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates = DefaultSdkAutoConstructList
                .getInstance();

        private String tableName;

        private AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate;

        private List<ReplicaAutoScalingUpdate> replicaUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableReplicaAutoScalingRequest model) {
            super(model);
            globalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            tableName(model.tableName);
            provisionedWriteCapacityAutoScalingUpdate(model.provisionedWriteCapacityAutoScalingUpdate);
            replicaUpdates(model.replicaUpdates);
        }

        public final List<GlobalSecondaryIndexAutoScalingUpdate.Builder> getGlobalSecondaryIndexUpdates() {
            List<GlobalSecondaryIndexAutoScalingUpdate.Builder> result = GlobalSecondaryIndexAutoScalingUpdateListCopier
                    .copyToBuilder(this.globalSecondaryIndexUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(
                Collection<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexAutoScalingUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexAutoScalingUpdate... globalSecondaryIndexUpdates) {
            globalSecondaryIndexUpdates(Arrays.asList(globalSecondaryIndexUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(
                Consumer<GlobalSecondaryIndexAutoScalingUpdate.Builder>... globalSecondaryIndexUpdates) {
            globalSecondaryIndexUpdates(Stream.of(globalSecondaryIndexUpdates)
                    .map(c -> GlobalSecondaryIndexAutoScalingUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexUpdates(
                Collection<GlobalSecondaryIndexAutoScalingUpdate.BuilderImpl> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexAutoScalingUpdateListCopier
                    .copyFromBuilder(globalSecondaryIndexUpdates);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final AutoScalingSettingsUpdate.Builder getProvisionedWriteCapacityAutoScalingUpdate() {
            return provisionedWriteCapacityAutoScalingUpdate != null ? provisionedWriteCapacityAutoScalingUpdate.toBuilder()
                    : null;
        }

        @Override
        public final Builder provisionedWriteCapacityAutoScalingUpdate(
                AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate) {
            this.provisionedWriteCapacityAutoScalingUpdate = provisionedWriteCapacityAutoScalingUpdate;
            return this;
        }

        public final void setProvisionedWriteCapacityAutoScalingUpdate(
                AutoScalingSettingsUpdate.BuilderImpl provisionedWriteCapacityAutoScalingUpdate) {
            this.provisionedWriteCapacityAutoScalingUpdate = provisionedWriteCapacityAutoScalingUpdate != null ? provisionedWriteCapacityAutoScalingUpdate
                    .build() : null;
        }

        public final List<ReplicaAutoScalingUpdate.Builder> getReplicaUpdates() {
            List<ReplicaAutoScalingUpdate.Builder> result = ReplicaAutoScalingUpdateListCopier.copyToBuilder(this.replicaUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicaUpdates(Collection<ReplicaAutoScalingUpdate> replicaUpdates) {
            this.replicaUpdates = ReplicaAutoScalingUpdateListCopier.copy(replicaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(ReplicaAutoScalingUpdate... replicaUpdates) {
            replicaUpdates(Arrays.asList(replicaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(Consumer<ReplicaAutoScalingUpdate.Builder>... replicaUpdates) {
            replicaUpdates(Stream.of(replicaUpdates).map(c -> ReplicaAutoScalingUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaUpdates(Collection<ReplicaAutoScalingUpdate.BuilderImpl> replicaUpdates) {
            this.replicaUpdates = ReplicaAutoScalingUpdateListCopier.copyFromBuilder(replicaUpdates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableReplicaAutoScalingRequest build() {
            return new UpdateTableReplicaAutoScalingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
