/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;
import software.amazon.awssdk.profiles.ProfileFile;

@SdkInternalApi
final class DynamoDbRetryPolicy {
    private static final int LEGACY_MAX_ERROR_RETRY = 8;
    private static final int STANDARD_MAX_ERROR_RETRY = 8;
    private static final Duration LEGACY_BASE_DELAY = Duration.ofMillis(25L);
    private static final BackoffStrategy LEGACY_BACKOFF_STRATEGY = FullJitterBackoffStrategy.builder().baseDelay(LEGACY_BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();

    private DynamoDbRetryPolicy() {
    }

    public static RetryPolicy resolveRetryPolicy(SdkClientConfiguration config) {
        RetryPolicy configuredRetryPolicy = (RetryPolicy)config.option((ClientOption)SdkClientOption.RETRY_POLICY);
        if (configuredRetryPolicy != null) {
            return configuredRetryPolicy;
        }
        RetryMode retryMode = RetryMode.resolver().profileFile(() -> (ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).resolve();
        switch (retryMode) {
            case LEGACY: {
                return AwsRetryPolicy.forRetryMode((RetryMode)RetryMode.LEGACY).toBuilder().additionalRetryConditionsAllowed(false).numRetries(Integer.valueOf(8)).backoffStrategy(LEGACY_BACKOFF_STRATEGY).build();
            }
            case STANDARD: {
                return AwsRetryPolicy.forRetryMode((RetryMode)retryMode).toBuilder().additionalRetryConditionsAllowed(false).numRetries(Integer.valueOf(8)).build();
            }
        }
        throw new IllegalArgumentException("Unknown retry mode: " + retryMode);
    }
}

