/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteRequest> {
    private static final SdkField<Map<String, AttributeValue>> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Key").getter(DeleteRequest.getter(DeleteRequest::key)).setter(DeleteRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> key;

    private DeleteRequest(BuilderImpl builder) {
        this.key = builder.key;
    }

    public final boolean hasKey() {
        return this.key != null && !(this.key instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> key() {
        return this.key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKey() ? this.key() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRequest)) {
            return false;
        }
        DeleteRequest other = (DeleteRequest)obj;
        return this.hasKey() == other.hasKey() && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRequest").add("Key", this.hasKey() ? this.key() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRequest, T> g) {
        return obj -> g.apply((DeleteRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> key = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRequest model) {
            this.key(model.key);
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            if (this.key instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.key != null ? CollectionUtils.mapValues(this.key, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        public DeleteRequest build() {
            return new DeleteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteRequest> {
        public Builder key(Map<String, AttributeValue> var1);
    }
}

