/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the auto scaling configuration for a replica global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaGlobalSecondaryIndexAutoScalingDescription
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder, ReplicaGlobalSecondaryIndexAutoScalingDescription> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(ReplicaGlobalSecondaryIndexAutoScalingDescription::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(ReplicaGlobalSecondaryIndexAutoScalingDescription::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<AutoScalingSettingsDescription> PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField
            .<AutoScalingSettingsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedReadCapacityAutoScalingSettings")
            .getter(getter(ReplicaGlobalSecondaryIndexAutoScalingDescription::provisionedReadCapacityAutoScalingSettings))
            .setter(setter(Builder::provisionedReadCapacityAutoScalingSettings))
            .constructor(AutoScalingSettingsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ProvisionedReadCapacityAutoScalingSettings").build()).build();

    private static final SdkField<AutoScalingSettingsDescription> PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField
            .<AutoScalingSettingsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedWriteCapacityAutoScalingSettings")
            .getter(getter(ReplicaGlobalSecondaryIndexAutoScalingDescription::provisionedWriteCapacityAutoScalingSettings))
            .setter(setter(Builder::provisionedWriteCapacityAutoScalingSettings))
            .constructor(AutoScalingSettingsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ProvisionedWriteCapacityAutoScalingSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            INDEX_STATUS_FIELD, PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD,
            PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final String indexStatus;

    private final AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings;

    private final AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings;

    private ReplicaGlobalSecondaryIndexAutoScalingDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.indexStatus = builder.indexStatus;
        this.provisionedReadCapacityAutoScalingSettings = builder.provisionedReadCapacityAutoScalingSettings;
        this.provisionedWriteCapacityAutoScalingSettings = builder.provisionedWriteCapacityAutoScalingSettings;
    }

    /**
     * <p>
     * The name of the global secondary index.
     * </p>
     * 
     * @return The name of the global secondary index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The current state of the replica global secondary index:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The index is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The index is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The index is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The index is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The current state of the replica global secondary index:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The index is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The index is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The index is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The index is ready for use.
     *         </p>
     *         </li>
     * @see IndexStatus
     */
    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * The current state of the replica global secondary index:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The index is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The index is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The index is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The index is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The current state of the replica global secondary index:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The index is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The index is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The index is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The index is ready for use.
     *         </p>
     *         </li>
     * @see IndexStatus
     */
    public final String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * Returns the value of the ProvisionedReadCapacityAutoScalingSettings property for this object.
     * 
     * @return The value of the ProvisionedReadCapacityAutoScalingSettings property for this object.
     */
    public final AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings() {
        return provisionedReadCapacityAutoScalingSettings;
    }

    /**
     * Returns the value of the ProvisionedWriteCapacityAutoScalingSettings property for this object.
     * 
     * @return The value of the ProvisionedWriteCapacityAutoScalingSettings property for this object.
     */
    public final AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings() {
        return provisionedWriteCapacityAutoScalingSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedReadCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedWriteCapacityAutoScalingSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexAutoScalingDescription)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexAutoScalingDescription other = (ReplicaGlobalSecondaryIndexAutoScalingDescription) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && Objects.equals(provisionedReadCapacityAutoScalingSettings(),
                        other.provisionedReadCapacityAutoScalingSettings())
                && Objects.equals(provisionedWriteCapacityAutoScalingSettings(),
                        other.provisionedWriteCapacityAutoScalingSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaGlobalSecondaryIndexAutoScalingDescription").add("IndexName", indexName())
                .add("IndexStatus", indexStatusAsString())
                .add("ProvisionedReadCapacityAutoScalingSettings", provisionedReadCapacityAutoScalingSettings())
                .add("ProvisionedWriteCapacityAutoScalingSettings", provisionedWriteCapacityAutoScalingSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "ProvisionedReadCapacityAutoScalingSettings":
            return Optional.ofNullable(clazz.cast(provisionedReadCapacityAutoScalingSettings()));
        case "ProvisionedWriteCapacityAutoScalingSettings":
            return Optional.ofNullable(clazz.cast(provisionedWriteCapacityAutoScalingSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaGlobalSecondaryIndexAutoScalingDescription, T> g) {
        return obj -> g.apply((ReplicaGlobalSecondaryIndexAutoScalingDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexAutoScalingDescription> {
        /**
         * <p>
         * The name of the global secondary index.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The current state of the replica global secondary index:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The index is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The index is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The index is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The index is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexStatus
         *        The current state of the replica global secondary index:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The index is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The index is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The index is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The index is ready for use.
         *        </p>
         *        </li>
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * The current state of the replica global secondary index:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The index is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The index is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The index is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The index is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexStatus
         *        The current state of the replica global secondary index:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The index is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The index is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The index is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The index is ready for use.
         *        </p>
         *        </li>
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * Sets the value of the ProvisionedReadCapacityAutoScalingSettings property for this object.
         *
         * @param provisionedReadCapacityAutoScalingSettings
         *        The new value for the ProvisionedReadCapacityAutoScalingSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings);

        /**
         * Sets the value of the ProvisionedReadCapacityAutoScalingSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsDescription.Builder} avoiding
         * the need to create one manually via {@link AutoScalingSettingsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #provisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription)}.
         * 
         * @param provisionedReadCapacityAutoScalingSettings
         *        a consumer that will call methods on {@link AutoScalingSettingsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription)
         */
        default Builder provisionedReadCapacityAutoScalingSettings(
                Consumer<AutoScalingSettingsDescription.Builder> provisionedReadCapacityAutoScalingSettings) {
            return provisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription.builder()
                    .applyMutation(provisionedReadCapacityAutoScalingSettings).build());
        }

        /**
         * Sets the value of the ProvisionedWriteCapacityAutoScalingSettings property for this object.
         *
         * @param provisionedWriteCapacityAutoScalingSettings
         *        The new value for the ProvisionedWriteCapacityAutoScalingSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings);

        /**
         * Sets the value of the ProvisionedWriteCapacityAutoScalingSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsDescription.Builder} avoiding
         * the need to create one manually via {@link AutoScalingSettingsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #provisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription)}.
         * 
         * @param provisionedWriteCapacityAutoScalingSettings
         *        a consumer that will call methods on {@link AutoScalingSettingsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription)
         */
        default Builder provisionedWriteCapacityAutoScalingSettings(
                Consumer<AutoScalingSettingsDescription.Builder> provisionedWriteCapacityAutoScalingSettings) {
            return provisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription.builder()
                    .applyMutation(provisionedWriteCapacityAutoScalingSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private String indexStatus;

        private AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings;

        private AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexAutoScalingDescription model) {
            indexName(model.indexName);
            indexStatus(model.indexStatus);
            provisionedReadCapacityAutoScalingSettings(model.provisionedReadCapacityAutoScalingSettings);
            provisionedWriteCapacityAutoScalingSettings(model.provisionedWriteCapacityAutoScalingSettings);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final AutoScalingSettingsDescription.Builder getProvisionedReadCapacityAutoScalingSettings() {
            return provisionedReadCapacityAutoScalingSettings != null ? provisionedReadCapacityAutoScalingSettings.toBuilder()
                    : null;
        }

        @Override
        public final Builder provisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings) {
            this.provisionedReadCapacityAutoScalingSettings = provisionedReadCapacityAutoScalingSettings;
            return this;
        }

        public final void setProvisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription.BuilderImpl provisionedReadCapacityAutoScalingSettings) {
            this.provisionedReadCapacityAutoScalingSettings = provisionedReadCapacityAutoScalingSettings != null ? provisionedReadCapacityAutoScalingSettings
                    .build() : null;
        }

        public final AutoScalingSettingsDescription.Builder getProvisionedWriteCapacityAutoScalingSettings() {
            return provisionedWriteCapacityAutoScalingSettings != null ? provisionedWriteCapacityAutoScalingSettings.toBuilder()
                    : null;
        }

        @Override
        public final Builder provisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings) {
            this.provisionedWriteCapacityAutoScalingSettings = provisionedWriteCapacityAutoScalingSettings;
            return this;
        }

        public final void setProvisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription.BuilderImpl provisionedWriteCapacityAutoScalingSettings) {
            this.provisionedWriteCapacityAutoScalingSettings = provisionedWriteCapacityAutoScalingSettings != null ? provisionedWriteCapacityAutoScalingSettings
                    .build() : null;
        }

        @Override
        public ReplicaGlobalSecondaryIndexAutoScalingDescription build() {
            return new ReplicaGlobalSecondaryIndexAutoScalingDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
