/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class KinesisDataStreamDestinationsCopier {
    static List<KinesisDataStreamDestination> copy(Collection<KinesisDataStreamDestination> kinesisDataStreamDestinationsParam) {
        if (kinesisDataStreamDestinationsParam == null || kinesisDataStreamDestinationsParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<KinesisDataStreamDestination> kinesisDataStreamDestinationsParamCopy = new ArrayList<>(
                kinesisDataStreamDestinationsParam);
        return Collections.unmodifiableList(kinesisDataStreamDestinationsParamCopy);
    }

    static List<KinesisDataStreamDestination> copyFromBuilder(
            Collection<? extends KinesisDataStreamDestination.Builder> kinesisDataStreamDestinationsParam) {
        if (kinesisDataStreamDestinationsParam == null
                || kinesisDataStreamDestinationsParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(kinesisDataStreamDestinationsParam.stream().map(KinesisDataStreamDestination.Builder::build)
                .collect(toList()));
    }
}
