/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Endpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Endpoint> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(Endpoint.getter(Endpoint::address)).setter(Endpoint.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<Long> CACHE_PERIOD_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CachePeriodInMinutes").getter(Endpoint.getter(Endpoint::cachePeriodInMinutes)).setter(Endpoint.setter(Builder::cachePeriodInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePeriodInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, CACHE_PERIOD_IN_MINUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String address;
    private final Long cachePeriodInMinutes;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.cachePeriodInMinutes = builder.cachePeriodInMinutes;
    }

    public final String address() {
        return this.address;
    }

    public final Long cachePeriodInMinutes() {
        return this.cachePeriodInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePeriodInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.cachePeriodInMinutes(), other.cachePeriodInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"Endpoint").add("Address", (Object)this.address()).add("CachePeriodInMinutes", (Object)this.cachePeriodInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "CachePeriodInMinutes": {
                return Optional.ofNullable(clazz.cast(this.cachePeriodInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private Long cachePeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.address(model.address);
            this.cachePeriodInMinutes(model.cachePeriodInMinutes);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Long getCachePeriodInMinutes() {
            return this.cachePeriodInMinutes;
        }

        @Override
        public final Builder cachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
            return this;
        }

        public final void setCachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Endpoint> {
        public Builder address(String var1);

        public Builder cachePeriodInMinutes(Long var1);
    }
}

