/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.CreateReplicationGroupMemberAction;
import software.amazon.awssdk.services.dynamodb.model.DeleteReplicationGroupMemberAction;
import software.amazon.awssdk.services.dynamodb.model.UpdateReplicationGroupMemberAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationGroupUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationGroupUpdate> {
    private static final SdkField<CreateReplicationGroupMemberAction> CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Create").getter(ReplicationGroupUpdate.getter(ReplicationGroupUpdate::create)).setter(ReplicationGroupUpdate.setter(Builder::create)).constructor(CreateReplicationGroupMemberAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Create").build()}).build();
    private static final SdkField<UpdateReplicationGroupMemberAction> UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Update").getter(ReplicationGroupUpdate.getter(ReplicationGroupUpdate::update)).setter(ReplicationGroupUpdate.setter(Builder::update)).constructor(UpdateReplicationGroupMemberAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Update").build()}).build();
    private static final SdkField<DeleteReplicationGroupMemberAction> DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Delete").getter(ReplicationGroupUpdate.getter(ReplicationGroupUpdate::delete)).setter(ReplicationGroupUpdate.setter(Builder::delete)).constructor(DeleteReplicationGroupMemberAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_FIELD, UPDATE_FIELD, DELETE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CreateReplicationGroupMemberAction create;
    private final UpdateReplicationGroupMemberAction update;
    private final DeleteReplicationGroupMemberAction delete;

    private ReplicationGroupUpdate(BuilderImpl builder) {
        this.create = builder.create;
        this.update = builder.update;
        this.delete = builder.delete;
    }

    public CreateReplicationGroupMemberAction create() {
        return this.create;
    }

    public UpdateReplicationGroupMemberAction update() {
        return this.update;
    }

    public DeleteReplicationGroupMemberAction delete() {
        return this.delete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.create());
        hashCode = 31 * hashCode + Objects.hashCode(this.update());
        hashCode = 31 * hashCode + Objects.hashCode(this.delete());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupUpdate)) {
            return false;
        }
        ReplicationGroupUpdate other = (ReplicationGroupUpdate)obj;
        return Objects.equals(this.create(), other.create()) && Objects.equals(this.update(), other.update()) && Objects.equals(this.delete(), other.delete());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationGroupUpdate").add("Create", (Object)this.create()).add("Update", (Object)this.update()).add("Delete", (Object)this.delete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Create": {
                return Optional.ofNullable(clazz.cast(this.create()));
            }
            case "Update": {
                return Optional.ofNullable(clazz.cast(this.update()));
            }
            case "Delete": {
                return Optional.ofNullable(clazz.cast(this.delete()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupUpdate, T> g) {
        return obj -> g.apply((ReplicationGroupUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CreateReplicationGroupMemberAction create;
        private UpdateReplicationGroupMemberAction update;
        private DeleteReplicationGroupMemberAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupUpdate model) {
            this.create(model.create);
            this.update(model.update);
            this.delete(model.delete);
        }

        public final CreateReplicationGroupMemberAction.Builder getCreate() {
            return this.create != null ? this.create.toBuilder() : null;
        }

        @Override
        public final Builder create(CreateReplicationGroupMemberAction create) {
            this.create = create;
            return this;
        }

        public final void setCreate(CreateReplicationGroupMemberAction.BuilderImpl create) {
            this.create = create != null ? create.build() : null;
        }

        public final UpdateReplicationGroupMemberAction.Builder getUpdate() {
            return this.update != null ? this.update.toBuilder() : null;
        }

        @Override
        public final Builder update(UpdateReplicationGroupMemberAction update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(UpdateReplicationGroupMemberAction.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        public final DeleteReplicationGroupMemberAction.Builder getDelete() {
            return this.delete != null ? this.delete.toBuilder() : null;
        }

        @Override
        public final Builder delete(DeleteReplicationGroupMemberAction delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(DeleteReplicationGroupMemberAction.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        public ReplicationGroupUpdate build() {
            return new ReplicationGroupUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationGroupUpdate> {
        public Builder create(CreateReplicationGroupMemberAction var1);

        default public Builder create(Consumer<CreateReplicationGroupMemberAction.Builder> create) {
            return this.create((CreateReplicationGroupMemberAction)((CreateReplicationGroupMemberAction.Builder)CreateReplicationGroupMemberAction.builder().applyMutation(create)).build());
        }

        public Builder update(UpdateReplicationGroupMemberAction var1);

        default public Builder update(Consumer<UpdateReplicationGroupMemberAction.Builder> update) {
            return this.update((UpdateReplicationGroupMemberAction)((UpdateReplicationGroupMemberAction.Builder)UpdateReplicationGroupMemberAction.builder().applyMutation(update)).build());
        }

        public Builder delete(DeleteReplicationGroupMemberAction var1);

        default public Builder delete(Consumer<DeleteReplicationGroupMemberAction.Builder> delete) {
            return this.delete((DeleteReplicationGroupMemberAction)((DeleteReplicationGroupMemberAction.Builder)DeleteReplicationGroupMemberAction.builder().applyMutation(delete)).build());
        }
    }
}

