/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportSummariesCopier;
import software.amazon.awssdk.services.dynamodb.model.ExportSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExportsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ListExportsResponse> {
    private static final SdkField<List<ExportSummary>> EXPORT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportSummaries").getter(ListExportsResponse.getter(ListExportsResponse::exportSummaries)).setter(ListExportsResponse.setter(Builder::exportSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExportsResponse.getter(ListExportsResponse::nextToken)).setter(ListExportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExportSummary> exportSummaries;
    private final String nextToken;

    private ListExportsResponse(BuilderImpl builder) {
        super(builder);
        this.exportSummaries = builder.exportSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasExportSummaries() {
        return this.exportSummaries != null && !(this.exportSummaries instanceof SdkAutoConstructList);
    }

    public List<ExportSummary> exportSummaries() {
        return this.exportSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportSummaries() ? this.exportSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse)((Object)obj);
        return this.hasExportSummaries() == other.hasExportSummaries() && Objects.equals(this.exportSummaries(), other.exportSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListExportsResponse").add("ExportSummaries", this.hasExportSummaries() ? this.exportSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportSummaries": {
                return Optional.ofNullable(clazz.cast(this.exportSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExportsResponse, T> g) {
        return obj -> g.apply((ListExportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<ExportSummary> exportSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            super(model);
            this.exportSummaries(model.exportSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ExportSummary.Builder> getExportSummaries() {
            if (this.exportSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportSummaries != null ? (Collection)this.exportSummaries.stream().map(ExportSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportSummaries(Collection<ExportSummary> exportSummaries) {
            this.exportSummaries = ExportSummariesCopier.copy(exportSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSummaries(ExportSummary ... exportSummaries) {
            this.exportSummaries(Arrays.asList(exportSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSummaries(Consumer<ExportSummary.Builder> ... exportSummaries) {
            this.exportSummaries(Stream.of(exportSummaries).map(c -> (ExportSummary)((ExportSummary.Builder)ExportSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExportSummaries(Collection<ExportSummary.BuilderImpl> exportSummaries) {
            this.exportSummaries = ExportSummariesCopier.copyFromBuilder(exportSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExportsResponse> {
        public Builder exportSummaries(Collection<ExportSummary> var1);

        public Builder exportSummaries(ExportSummary ... var1);

        public Builder exportSummaries(Consumer<ExportSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

