/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactWriteItemsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<TransactWriteItemsRequest.Builder, TransactWriteItemsRequest> {
    private static final SdkField<List<TransactWriteItem>> TRANSACT_ITEMS_FIELD = SdkField
            .<List<TransactWriteItem>> builder(MarshallingType.LIST)
            .memberName("TransactItems")
            .getter(getter(TransactWriteItemsRequest::transactItems))
            .setter(setter(Builder::transactItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransactWriteItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransactWriteItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReturnConsumedCapacity").getter(getter(TransactWriteItemsRequest::returnConsumedCapacityAsString))
            .setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final SdkField<String> RETURN_ITEM_COLLECTION_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReturnItemCollectionMetrics")
            .getter(getter(TransactWriteItemsRequest::returnItemCollectionMetricsAsString))
            .setter(setter(Builder::returnItemCollectionMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnItemCollectionMetrics")
                    .build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(TransactWriteItemsRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACT_ITEMS_FIELD,
            RETURN_CONSUMED_CAPACITY_FIELD, RETURN_ITEM_COLLECTION_METRICS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final List<TransactWriteItem> transactItems;

    private final String returnConsumedCapacity;

    private final String returnItemCollectionMetrics;

    private final String clientRequestToken;

    private TransactWriteItemsRequest(BuilderImpl builder) {
        super(builder);
        this.transactItems = builder.transactItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * Returns true if the TransactItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTransactItems() {
        return transactItems != null && !(transactItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a
     * <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can
     * operate on items in different tables, but the tables must reside in the same AWS account and Region, and no two
     * of them can operate on the same item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransactItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a
     *         <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These
     *         can operate on items in different tables, but the tables must reside in the same AWS account and Region,
     *         and no two of them can operate on the same item.
     */
    public List<TransactWriteItem> transactItems() {
        return transactItems;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections (if any), that were modified during the operation and are returned in the
     * response. If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections (if any), that were modified during the operation and are
     *         returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(returnItemCollectionMetrics);
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections (if any), that were modified during the operation and are returned in the
     * response. If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections (if any), that were modified during the operation and are
     *         returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public String returnItemCollectionMetricsAsString() {
        return returnItemCollectionMetrics;
    }

    /**
     * <p>
     * Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code> idempotent, meaning
     * that multiple identical calls have the same effect as one single call.
     * </p>
     * <p>
     * Although multiple identical calls using the same client request token produce the same result on the server (no
     * side effects), the responses to the calls might not be the same. If the <code>ReturnConsumedCapacity&gt;</code>
     * parameter is set, then the initial <code>TransactWriteItems</code> call returns the amount of write capacity
     * units consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with the same client token
     * return the number of read capacity units consumed in reading the item.
     * </p>
     * <p>
     * A client request token is valid for 10 minutes after the first request that uses it is completed. After 10
     * minutes, any request with the same client token is treated as a new request. Do not resubmit the same request
     * with the same client token for more than 10 minutes, or the result might not be idempotent.
     * </p>
     * <p>
     * If you submit a request with the same client token but a change in other parameters within the 10-minute
     * idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
     * </p>
     * 
     * @return Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code> idempotent,
     *         meaning that multiple identical calls have the same effect as one single call.</p>
     *         <p>
     *         Although multiple identical calls using the same client request token produce the same result on the
     *         server (no side effects), the responses to the calls might not be the same. If the
     *         <code>ReturnConsumedCapacity&gt;</code> parameter is set, then the initial
     *         <code>TransactWriteItems</code> call returns the amount of write capacity units consumed in making the
     *         changes. Subsequent <code>TransactWriteItems</code> calls with the same client token return the number of
     *         read capacity units consumed in reading the item.
     *         </p>
     *         <p>
     *         A client request token is valid for 10 minutes after the first request that uses it is completed. After
     *         10 minutes, any request with the same client token is treated as a new request. Do not resubmit the same
     *         request with the same client token for more than 10 minutes, or the result might not be idempotent.
     *         </p>
     *         <p>
     *         If you submit a request with the same client token but a change in other parameters within the 10-minute
     *         idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransactItems() ? transactItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(returnItemCollectionMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactWriteItemsRequest)) {
            return false;
        }
        TransactWriteItemsRequest other = (TransactWriteItemsRequest) obj;
        return hasTransactItems() == other.hasTransactItems() && Objects.equals(transactItems(), other.transactItems())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString())
                && Objects.equals(returnItemCollectionMetricsAsString(), other.returnItemCollectionMetricsAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransactWriteItemsRequest").add("TransactItems", hasTransactItems() ? transactItems() : null)
                .add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .add("ReturnItemCollectionMetrics", returnItemCollectionMetricsAsString())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactItems":
            return Optional.ofNullable(clazz.cast(transactItems()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        case "ReturnItemCollectionMetrics":
            return Optional.ofNullable(clazz.cast(returnItemCollectionMetricsAsString()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactWriteItemsRequest, T> g) {
        return obj -> g.apply((TransactWriteItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, TransactWriteItemsRequest> {
        /**
         * <p>
         * An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a
         * <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can
         * operate on items in different tables, but the tables must reside in the same AWS account and Region, and no
         * two of them can operate on the same item.
         * </p>
         * 
         * @param transactItems
         *        An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a
         *        <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object.
         *        These can operate on items in different tables, but the tables must reside in the same AWS account and
         *        Region, and no two of them can operate on the same item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactItems(Collection<TransactWriteItem> transactItems);

        /**
         * <p>
         * An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a
         * <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can
         * operate on items in different tables, but the tables must reside in the same AWS account and Region, and no
         * two of them can operate on the same item.
         * </p>
         * 
         * @param transactItems
         *        An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a
         *        <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object.
         *        These can operate on items in different tables, but the tables must reside in the same AWS account and
         *        Region, and no two of them can operate on the same item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactItems(TransactWriteItem... transactItems);

        /**
         * <p>
         * An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a
         * <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can
         * operate on items in different tables, but the tables must reside in the same AWS account and Region, and no
         * two of them can operate on the same item.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TransactWriteItem>.Builder} avoiding the
         * need to create one manually via {@link List<TransactWriteItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransactWriteItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #transactItems(List<TransactWriteItem>)}.
         * 
         * @param transactItems
         *        a consumer that will call methods on {@link List<TransactWriteItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transactItems(List<TransactWriteItem>)
         */
        Builder transactItems(Consumer<TransactWriteItem.Builder>... transactItems);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections (if any), that were modified during the operation and are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections (if any), that were modified during the operation and are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(String returnItemCollectionMetrics);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections (if any), that were modified during the operation and are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections (if any), that were modified during the operation and are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics);

        /**
         * <p>
         * Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code> idempotent,
         * meaning that multiple identical calls have the same effect as one single call.
         * </p>
         * <p>
         * Although multiple identical calls using the same client request token produce the same result on the server
         * (no side effects), the responses to the calls might not be the same. If the
         * <code>ReturnConsumedCapacity&gt;</code> parameter is set, then the initial <code>TransactWriteItems</code>
         * call returns the amount of write capacity units consumed in making the changes. Subsequent
         * <code>TransactWriteItems</code> calls with the same client token return the number of read capacity units
         * consumed in reading the item.
         * </p>
         * <p>
         * A client request token is valid for 10 minutes after the first request that uses it is completed. After 10
         * minutes, any request with the same client token is treated as a new request. Do not resubmit the same request
         * with the same client token for more than 10 minutes, or the result might not be idempotent.
         * </p>
         * <p>
         * If you submit a request with the same client token but a change in other parameters within the 10-minute
         * idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
         * </p>
         * 
         * @param clientRequestToken
         *        Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code>
         *        idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
         *        <p>
         *        Although multiple identical calls using the same client request token produce the same result on the
         *        server (no side effects), the responses to the calls might not be the same. If the
         *        <code>ReturnConsumedCapacity&gt;</code> parameter is set, then the initial
         *        <code>TransactWriteItems</code> call returns the amount of write capacity units consumed in making the
         *        changes. Subsequent <code>TransactWriteItems</code> calls with the same client token return the number
         *        of read capacity units consumed in reading the item.
         *        </p>
         *        <p>
         *        A client request token is valid for 10 minutes after the first request that uses it is completed.
         *        After 10 minutes, any request with the same client token is treated as a new request. Do not resubmit
         *        the same request with the same client token for more than 10 minutes, or the result might not be
         *        idempotent.
         *        </p>
         *        <p>
         *        If you submit a request with the same client token but a change in other parameters within the
         *        10-minute idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<TransactWriteItem> transactItems = DefaultSdkAutoConstructList.getInstance();

        private String returnConsumedCapacity;

        private String returnItemCollectionMetrics;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactWriteItemsRequest model) {
            super(model);
            transactItems(model.transactItems);
            returnConsumedCapacity(model.returnConsumedCapacity);
            returnItemCollectionMetrics(model.returnItemCollectionMetrics);
            clientRequestToken(model.clientRequestToken);
        }

        public final Collection<TransactWriteItem.Builder> getTransactItems() {
            if (transactItems instanceof SdkAutoConstructList) {
                return null;
            }
            return transactItems != null ? transactItems.stream().map(TransactWriteItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder transactItems(Collection<TransactWriteItem> transactItems) {
            this.transactItems = TransactWriteItemListCopier.copy(transactItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactItems(TransactWriteItem... transactItems) {
            transactItems(Arrays.asList(transactItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactItems(Consumer<TransactWriteItem.Builder>... transactItems) {
            transactItems(Stream.of(transactItems).map(c -> TransactWriteItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTransactItems(Collection<TransactWriteItem.BuilderImpl> transactItems) {
            this.transactItems = TransactWriteItemListCopier.copyFromBuilder(transactItems);
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransactWriteItemsRequest build() {
            return new TransactWriteItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
