/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Kinesis data stream destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisDataStreamDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisDataStreamDestination.Builder, KinesisDataStreamDestination> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(KinesisDataStreamDestination::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationStatus").getter(getter(KinesisDataStreamDestination::destinationStatusAsString))
            .setter(setter(Builder::destinationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()).build();

    private static final SdkField<String> DESTINATION_STATUS_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationStatusDescription")
            .getter(getter(KinesisDataStreamDestination::destinationStatusDescription))
            .setter(setter(Builder::destinationStatusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatusDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            DESTINATION_STATUS_FIELD, DESTINATION_STATUS_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final String destinationStatus;

    private final String destinationStatusDescription;

    private KinesisDataStreamDestination(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
        this.destinationStatusDescription = builder.destinationStatusDescription;
    }

    /**
     * <p>
     * The ARN for a specific Kinesis data stream.
     * </p>
     * 
     * @return The ARN for a specific Kinesis data stream.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The current status of replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of replication.
     * @see DestinationStatus
     */
    public DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(destinationStatus);
    }

    /**
     * <p>
     * The current status of replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of replication.
     * @see DestinationStatus
     */
    public String destinationStatusAsString() {
        return destinationStatus;
    }

    /**
     * <p>
     * The human-readable string that corresponds to the replica status.
     * </p>
     * 
     * @return The human-readable string that corresponds to the replica status.
     */
    public String destinationStatusDescription() {
        return destinationStatusDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStatusDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisDataStreamDestination)) {
            return false;
        }
        KinesisDataStreamDestination other = (KinesisDataStreamDestination) obj;
        return Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(destinationStatusAsString(), other.destinationStatusAsString())
                && Objects.equals(destinationStatusDescription(), other.destinationStatusDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KinesisDataStreamDestination").add("StreamArn", streamArn())
                .add("DestinationStatus", destinationStatusAsString())
                .add("DestinationStatusDescription", destinationStatusDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "DestinationStatus":
            return Optional.ofNullable(clazz.cast(destinationStatusAsString()));
        case "DestinationStatusDescription":
            return Optional.ofNullable(clazz.cast(destinationStatusDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisDataStreamDestination, T> g) {
        return obj -> g.apply((KinesisDataStreamDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisDataStreamDestination> {
        /**
         * <p>
         * The ARN for a specific Kinesis data stream.
         * </p>
         * 
         * @param streamArn
         *        The ARN for a specific Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The current status of replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(String destinationStatus);

        /**
         * <p>
         * The current status of replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(DestinationStatus destinationStatus);

        /**
         * <p>
         * The human-readable string that corresponds to the replica status.
         * </p>
         * 
         * @param destinationStatusDescription
         *        The human-readable string that corresponds to the replica status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStatusDescription(String destinationStatusDescription);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String destinationStatus;

        private String destinationStatusDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisDataStreamDestination model) {
            streamArn(model.streamArn);
            destinationStatus(model.destinationStatus);
            destinationStatusDescription(model.destinationStatusDescription);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getDestinationStatus() {
            return destinationStatus;
        }

        @Override
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        public final String getDestinationStatusDescription() {
            return destinationStatusDescription;
        }

        @Override
        public final Builder destinationStatusDescription(String destinationStatusDescription) {
            this.destinationStatusDescription = destinationStatusDescription;
            return this;
        }

        public final void setDestinationStatusDescription(String destinationStatusDescription) {
            this.destinationStatusDescription = destinationStatusDescription;
        }

        @Override
        public KinesisDataStreamDestination build() {
            return new KinesisDataStreamDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
