/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a replica to be created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationGroupMemberAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateReplicationGroupMemberAction.Builder, CreateReplicationGroupMemberAction> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(CreateReplicationGroupMemberAction::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSMasterKeyId").getter(getter(CreateReplicationGroupMemberAction::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()).build();

    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField
            .<ProvisionedThroughputOverride> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedThroughputOverride")
            .getter(getter(CreateReplicationGroupMemberAction::provisionedThroughputOverride))
            .setter(setter(Builder::provisionedThroughputOverride))
            .constructor(ProvisionedThroughputOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride")
                    .build()).build();

    private static final SdkField<List<ReplicaGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<ReplicaGlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(CreateReplicationGroupMemberAction::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaGlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaGlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String kmsMasterKeyId;

    private final ProvisionedThroughputOverride provisionedThroughputOverride;

    private final List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes;

    private CreateReplicationGroupMemberAction(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
    }

    /**
     * <p>
     * The Region where the new replica will be created.
     * </p>
     * 
     * @return The Region where the new replica will be created.
     */
    public String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The AWS KMS customer master key (CMK) that should be used for AWS KMS encryption in the new replica. To specify a
     * CMK, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this
     * parameter if the key is different from the default DynamoDB KMS master key alias/aws/dynamodb.
     * </p>
     * 
     * @return The AWS KMS customer master key (CMK) that should be used for AWS KMS encryption in the new replica. To
     *         specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should
     *         only provide this parameter if the key is different from the default DynamoDB KMS master key
     *         alias/aws/dynamodb.
     */
    public String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * <p>
     * Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
     * settings.
     * </p>
     * 
     * @return Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
     *         settings.
     */
    public ProvisionedThroughputOverride provisionedThroughputOverride() {
        return provisionedThroughputOverride;
    }

    /**
     * Returns true if the GlobalSecondaryIndexes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replica-specific global secondary index settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalSecondaryIndexes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Replica-specific global secondary index settings.
     */
    public List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupMemberAction)) {
            return false;
        }
        CreateReplicationGroupMemberAction other = (CreateReplicationGroupMemberAction) obj;
        return Objects.equals(regionName(), other.regionName()) && Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId())
                && Objects.equals(provisionedThroughputOverride(), other.provisionedThroughputOverride())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReplicationGroupMemberAction").add("RegionName", regionName())
                .add("KMSMasterKeyId", kmsMasterKeyId()).add("ProvisionedThroughputOverride", provisionedThroughputOverride())
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "KMSMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "ProvisionedThroughputOverride":
            return Optional.ofNullable(clazz.cast(provisionedThroughputOverride()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationGroupMemberAction, T> g) {
        return obj -> g.apply((CreateReplicationGroupMemberAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateReplicationGroupMemberAction> {
        /**
         * <p>
         * The Region where the new replica will be created.
         * </p>
         * 
         * @param regionName
         *        The Region where the new replica will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The AWS KMS customer master key (CMK) that should be used for AWS KMS encryption in the new replica. To
         * specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should
         * only provide this parameter if the key is different from the default DynamoDB KMS master key
         * alias/aws/dynamodb.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The AWS KMS customer master key (CMK) that should be used for AWS KMS encryption in the new replica.
         *        To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you
         *        should only provide this parameter if the key is different from the default DynamoDB KMS master key
         *        alias/aws/dynamodb.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
         * settings.
         * </p>
         * 
         * @param provisionedThroughputOverride
         *        Replica-specific provisioned throughput. If not specified, uses the source table's provisioned
         *        throughput settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride);

        /**
         * <p>
         * Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput
         * settings.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughputOverride.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughputOverride#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughputOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedThroughputOverride(ProvisionedThroughputOverride)}
         * .
         * 
         * @param provisionedThroughputOverride
         *        a consumer that will call methods on {@link ProvisionedThroughputOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughputOverride(ProvisionedThroughputOverride)
         */
        default Builder provisionedThroughputOverride(
                Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return provisionedThroughputOverride(ProvisionedThroughputOverride.builder()
                    .applyMutation(provisionedThroughputOverride).build());
        }

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaGlobalSecondaryIndex>.Builder}
         * avoiding the need to create one manually via {@link List<ReplicaGlobalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaGlobalSecondaryIndex>.Builder#build()} is called
         * immediately and its result is passed to {@link #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List<ReplicaGlobalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder>... globalSecondaryIndexes);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String kmsMasterKeyId;

        private ProvisionedThroughputOverride provisionedThroughputOverride;

        private List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupMemberAction model) {
            regionName(model.regionName);
            kmsMasterKeyId(model.kmsMasterKeyId);
            provisionedThroughputOverride(model.provisionedThroughputOverride);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return provisionedThroughputOverride != null ? provisionedThroughputOverride.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build()
                    : null;
        }

        public final Collection<ReplicaGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            if (globalSecondaryIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return globalSecondaryIndexes != null ? globalSecondaryIndexes.stream().map(ReplicaGlobalSecondaryIndex::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> ReplicaGlobalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public CreateReplicationGroupMemberAction build() {
            return new CreateReplicationGroupMemberAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
