/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchExecuteStatementRequest extends DynamoDbRequest implements
        ToCopyableBuilder<BatchExecuteStatementRequest.Builder, BatchExecuteStatementRequest> {
    private static final SdkField<List<BatchStatementRequest>> STATEMENTS_FIELD = SdkField
            .<List<BatchStatementRequest>> builder(MarshallingType.LIST)
            .memberName("Statements")
            .getter(getter(BatchExecuteStatementRequest::statements))
            .setter(setter(Builder::statements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchStatementRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchStatementRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD));

    private final List<BatchStatementRequest> statements;

    private BatchExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.statements = builder.statements;
    }

    /**
     * Returns true if the Statements property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStatements() {
        return statements != null && !(statements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of PartiQL statements representing the batch to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of PartiQL statements representing the batch to run.
     */
    public List<BatchStatementRequest> statements() {
        return statements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStatements() ? statements() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementRequest)) {
            return false;
        }
        BatchExecuteStatementRequest other = (BatchExecuteStatementRequest) obj;
        return hasStatements() == other.hasStatements() && Objects.equals(statements(), other.statements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchExecuteStatementRequest").add("Statements", hasStatements() ? statements() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statements":
            return Optional.ofNullable(clazz.cast(statements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementRequest, T> g) {
        return obj -> g.apply((BatchExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchExecuteStatementRequest> {
        /**
         * <p>
         * The list of PartiQL statements representing the batch to run.
         * </p>
         * 
         * @param statements
         *        The list of PartiQL statements representing the batch to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(Collection<BatchStatementRequest> statements);

        /**
         * <p>
         * The list of PartiQL statements representing the batch to run.
         * </p>
         * 
         * @param statements
         *        The list of PartiQL statements representing the batch to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(BatchStatementRequest... statements);

        /**
         * <p>
         * The list of PartiQL statements representing the batch to run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchStatementRequest>.Builder} avoiding
         * the need to create one manually via {@link List<BatchStatementRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchStatementRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #statements(List<BatchStatementRequest>)}.
         * 
         * @param statements
         *        a consumer that will call methods on {@link List<BatchStatementRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statements(List<BatchStatementRequest>)
         */
        Builder statements(Consumer<BatchStatementRequest.Builder>... statements);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<BatchStatementRequest> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementRequest model) {
            super(model);
            statements(model.statements);
        }

        public final Collection<BatchStatementRequest.Builder> getStatements() {
            if (statements instanceof SdkAutoConstructList) {
                return null;
            }
            return statements != null ? statements.stream().map(BatchStatementRequest::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder statements(Collection<BatchStatementRequest> statements) {
            this.statements = PartiQLBatchRequestCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(BatchStatementRequest... statements) {
            statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<BatchStatementRequest.Builder>... statements) {
            statements(Stream.of(statements).map(c -> BatchStatementRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatements(Collection<BatchStatementRequest.BuilderImpl> statements) {
            this.statements = PartiQLBatchRequestCopier.copyFromBuilder(statements);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchExecuteStatementRequest build() {
            return new BatchExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
