/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.Replica;
import software.amazon.awssdk.services.dynamodb.model.ReplicaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalTable> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalTableName").getter(GlobalTable.getter(GlobalTable::globalTableName)).setter(GlobalTable.setter(Builder::globalTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()}).build();
    private static final SdkField<List<Replica>> REPLICATION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationGroup").getter(GlobalTable.getter(GlobalTable::replicationGroup)).setter(GlobalTable.setter(Builder::replicationGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Replica::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD, REPLICATION_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String globalTableName;
    private final List<Replica> replicationGroup;

    private GlobalTable(BuilderImpl builder) {
        this.globalTableName = builder.globalTableName;
        this.replicationGroup = builder.replicationGroup;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public boolean hasReplicationGroup() {
        return this.replicationGroup != null && !(this.replicationGroup instanceof SdkAutoConstructList);
    }

    public List<Replica> replicationGroup() {
        return this.replicationGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationGroup() ? this.replicationGroup() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTable)) {
            return false;
        }
        GlobalTable other = (GlobalTable)obj;
        return Objects.equals(this.globalTableName(), other.globalTableName()) && this.hasReplicationGroup() == other.hasReplicationGroup() && Objects.equals(this.replicationGroup(), other.replicationGroup());
    }

    public String toString() {
        return ToString.builder((String)"GlobalTable").add("GlobalTableName", (Object)this.globalTableName()).add("ReplicationGroup", this.hasReplicationGroup() ? this.replicationGroup() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
            case "ReplicationGroup": {
                return Optional.ofNullable(clazz.cast(this.replicationGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalTable, T> g) {
        return obj -> g.apply((GlobalTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String globalTableName;
        private List<Replica> replicationGroup = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTable model) {
            this.globalTableName(model.globalTableName);
            this.replicationGroup(model.replicationGroup);
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final Collection<Replica.Builder> getReplicationGroup() {
            if (this.replicationGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationGroup != null ? (Collection)this.replicationGroup.stream().map(Replica::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationGroup(Collection<Replica> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copy(replicationGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Replica ... replicationGroup) {
            this.replicationGroup(Arrays.asList(replicationGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Consumer<Replica.Builder> ... replicationGroup) {
            this.replicationGroup(Stream.of(replicationGroup).map(c -> (Replica)((Replica.Builder)Replica.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationGroup(Collection<Replica.BuilderImpl> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copyFromBuilder(replicationGroup);
        }

        public GlobalTable build() {
            return new GlobalTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalTable> {
        public Builder globalTableName(String var1);

        public Builder replicationGroup(Collection<Replica> var1);

        public Builder replicationGroup(Replica ... var1);

        public Builder replicationGroup(Consumer<Replica.Builder> ... var1);
    }
}

