/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaGlobalSecondaryIndexSettingsUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsUpdate> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(ReplicaGlobalSecondaryIndexSettingsUpdate.getter(ReplicaGlobalSecondaryIndexSettingsUpdate::indexName)).setter(ReplicaGlobalSecondaryIndexSettingsUpdate.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<Long> PROVISIONED_READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProvisionedReadCapacityUnits").getter(ReplicaGlobalSecondaryIndexSettingsUpdate.getter(ReplicaGlobalSecondaryIndexSettingsUpdate::provisionedReadCapacityUnits)).setter(ReplicaGlobalSecondaryIndexSettingsUpdate.setter(Builder::provisionedReadCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedReadCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettingsUpdate> PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedReadCapacityAutoScalingSettingsUpdate").getter(ReplicaGlobalSecondaryIndexSettingsUpdate.getter(ReplicaGlobalSecondaryIndexSettingsUpdate::provisionedReadCapacityAutoScalingSettingsUpdate)).setter(ReplicaGlobalSecondaryIndexSettingsUpdate.setter(Builder::provisionedReadCapacityAutoScalingSettingsUpdate)).constructor(AutoScalingSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedReadCapacityAutoScalingSettingsUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, PROVISIONED_READ_CAPACITY_UNITS_FIELD, PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final Long provisionedReadCapacityUnits;
    private final AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate;

    private ReplicaGlobalSecondaryIndexSettingsUpdate(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
        this.provisionedReadCapacityAutoScalingSettingsUpdate = builder.provisionedReadCapacityAutoScalingSettingsUpdate;
    }

    public String indexName() {
        return this.indexName;
    }

    public Long provisionedReadCapacityUnits() {
        return this.provisionedReadCapacityUnits;
    }

    public AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate() {
        return this.provisionedReadCapacityAutoScalingSettingsUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedReadCapacityAutoScalingSettingsUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexSettingsUpdate)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexSettingsUpdate other = (ReplicaGlobalSecondaryIndexSettingsUpdate)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.provisionedReadCapacityUnits(), other.provisionedReadCapacityUnits()) && Objects.equals(this.provisionedReadCapacityAutoScalingSettingsUpdate(), other.provisionedReadCapacityAutoScalingSettingsUpdate());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaGlobalSecondaryIndexSettingsUpdate").add("IndexName", (Object)this.indexName()).add("ProvisionedReadCapacityUnits", (Object)this.provisionedReadCapacityUnits()).add("ProvisionedReadCapacityAutoScalingSettingsUpdate", (Object)this.provisionedReadCapacityAutoScalingSettingsUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedReadCapacityUnits()));
            }
            case "ProvisionedReadCapacityAutoScalingSettingsUpdate": {
                return Optional.ofNullable(clazz.cast(this.provisionedReadCapacityAutoScalingSettingsUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaGlobalSecondaryIndexSettingsUpdate, T> g) {
        return obj -> g.apply((ReplicaGlobalSecondaryIndexSettingsUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private Long provisionedReadCapacityUnits;
        private AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexSettingsUpdate model) {
            this.indexName(model.indexName);
            this.provisionedReadCapacityUnits(model.provisionedReadCapacityUnits);
            this.provisionedReadCapacityAutoScalingSettingsUpdate(model.provisionedReadCapacityAutoScalingSettingsUpdate);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Long getProvisionedReadCapacityUnits() {
            return this.provisionedReadCapacityUnits;
        }

        @Override
        public final Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
            return this;
        }

        public final void setProvisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }

        public final AutoScalingSettingsUpdate.Builder getProvisionedReadCapacityAutoScalingSettingsUpdate() {
            return this.provisionedReadCapacityAutoScalingSettingsUpdate != null ? this.provisionedReadCapacityAutoScalingSettingsUpdate.toBuilder() : null;
        }

        @Override
        public final Builder provisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate) {
            this.provisionedReadCapacityAutoScalingSettingsUpdate = provisionedReadCapacityAutoScalingSettingsUpdate;
            return this;
        }

        public final void setProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.BuilderImpl provisionedReadCapacityAutoScalingSettingsUpdate) {
            this.provisionedReadCapacityAutoScalingSettingsUpdate = provisionedReadCapacityAutoScalingSettingsUpdate != null ? provisionedReadCapacityAutoScalingSettingsUpdate.build() : null;
        }

        public ReplicaGlobalSecondaryIndexSettingsUpdate build() {
            return new ReplicaGlobalSecondaryIndexSettingsUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsUpdate> {
        public Builder indexName(String var1);

        public Builder provisionedReadCapacityUnits(Long var1);

        public Builder provisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate var1);

        default public Builder provisionedReadCapacityAutoScalingSettingsUpdate(Consumer<AutoScalingSettingsUpdate.Builder> provisionedReadCapacityAutoScalingSettingsUpdate) {
            return this.provisionedReadCapacityAutoScalingSettingsUpdate((AutoScalingSettingsUpdate)((AutoScalingSettingsUpdate.Builder)AutoScalingSettingsUpdate.builder().applyMutation(provisionedReadCapacityAutoScalingSettingsUpdate)).build());
        }
    }
}

