/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.Tag;
import software.amazon.awssdk.services.dynamodb.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTableRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, CreateTableRequest> {
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeDefinitions").getter(CreateTableRequest.getter(CreateTableRequest::attributeDefinitions)).setter(CreateTableRequest.setter(Builder::attributeDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(CreateTableRequest.getter(CreateTableRequest::tableName)).setter(CreateTableRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeySchema").getter(CreateTableRequest.getter(CreateTableRequest::keySchema)).setter(CreateTableRequest.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySchemaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalSecondaryIndexes").getter(CreateTableRequest.getter(CreateTableRequest::localSecondaryIndexes)).setter(CreateTableRequest.setter(Builder::localSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(CreateTableRequest.getter(CreateTableRequest::globalSecondaryIndexes)).setter(CreateTableRequest.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingMode").getter(CreateTableRequest.getter(CreateTableRequest::billingModeAsString)).setter(CreateTableRequest.setter(Builder::billingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughput").getter(CreateTableRequest.getter(CreateTableRequest::provisionedThroughput)).setter(CreateTableRequest.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final SdkField<StreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSpecification").getter(CreateTableRequest.getter(CreateTableRequest::streamSpecification)).setter(CreateTableRequest.setter(Builder::streamSpecification)).constructor(StreamSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build()}).build();
    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSESpecification").getter(CreateTableRequest.getter(CreateTableRequest::sseSpecification)).setter(CreateTableRequest.setter(Builder::sseSpecification)).constructor(SSESpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTableRequest.getter(CreateTableRequest::tags)).setter(CreateTableRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD, TABLE_NAME_FIELD, KEY_SCHEMA_FIELD, LOCAL_SECONDARY_INDEXES_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, BILLING_MODE_FIELD, PROVISIONED_THROUGHPUT_FIELD, STREAM_SPECIFICATION_FIELD, SSE_SPECIFICATION_FIELD, TAGS_FIELD));
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final List<KeySchemaElement> keySchema;
    private final List<LocalSecondaryIndex> localSecondaryIndexes;
    private final List<GlobalSecondaryIndex> globalSecondaryIndexes;
    private final String billingMode;
    private final ProvisionedThroughput provisionedThroughput;
    private final StreamSpecification streamSpecification;
    private final SSESpecification sseSpecification;
    private final List<Tag> tags;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.billingMode = builder.billingMode;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.streamSpecification = builder.streamSpecification;
        this.sseSpecification = builder.sseSpecification;
        this.tags = builder.tags;
    }

    public boolean hasAttributeDefinitions() {
        return this.attributeDefinitions != null && !(this.attributeDefinitions instanceof SdkAutoConstructList);
    }

    public List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public String tableName() {
        return this.tableName;
    }

    public boolean hasKeySchema() {
        return this.keySchema != null && !(this.keySchema instanceof SdkAutoConstructList);
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public boolean hasLocalSecondaryIndexes() {
        return this.localSecondaryIndexes != null && !(this.localSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public List<LocalSecondaryIndex> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public List<GlobalSecondaryIndex> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public BillingMode billingMode() {
        return BillingMode.fromValue(this.billingMode);
    }

    public String billingModeAsString() {
        return this.billingMode;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public SSESpecification sseSpecification() {
        return this.sseSpecification;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.localSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)((Object)obj);
        return Objects.equals(this.attributeDefinitions(), other.attributeDefinitions()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.localSecondaryIndexes(), other.localSecondaryIndexes()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.billingModeAsString(), other.billingModeAsString()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.streamSpecification(), other.streamSpecification()) && Objects.equals(this.sseSpecification(), other.sseSpecification()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateTableRequest").add("AttributeDefinitions", this.attributeDefinitions()).add("TableName", (Object)this.tableName()).add("KeySchema", this.keySchema()).add("LocalSecondaryIndexes", this.localSecondaryIndexes()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).add("BillingMode", (Object)this.billingModeAsString()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("StreamSpecification", (Object)this.streamSpecification()).add("SSESpecification", (Object)this.sseSpecification()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeDefinitions": {
                return Optional.ofNullable(clazz.cast(this.attributeDefinitions()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "LocalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexes()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "BillingMode": {
                return Optional.ofNullable(clazz.cast(this.billingModeAsString()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "StreamSpecification": {
                return Optional.ofNullable(clazz.cast(this.streamSpecification()));
            }
            case "SSESpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String tableName;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private List<LocalSecondaryIndex> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private List<GlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private String billingMode;
        private ProvisionedThroughput provisionedThroughput;
        private StreamSpecification streamSpecification;
        private SSESpecification sseSpecification;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            this.attributeDefinitions(model.attributeDefinitions);
            this.tableName(model.tableName);
            this.keySchema(model.keySchema);
            this.localSecondaryIndexes(model.localSecondaryIndexes);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.billingMode(model.billingMode);
            this.provisionedThroughput(model.provisionedThroughput);
            this.streamSpecification(model.streamSpecification);
            this.sseSpecification(model.sseSpecification);
            this.tags(model.tags);
        }

        public final Collection<AttributeDefinition.Builder> getAttributeDefinitions() {
            return this.attributeDefinitions != null ? (Collection)this.attributeDefinitions.stream().map(AttributeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... attributeDefinitions) {
            this.attributeDefinitions(Stream.of(attributeDefinitions).map(c -> (AttributeDefinition)((AttributeDefinition.Builder)AttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Collection<LocalSecondaryIndex.Builder> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes != null ? (Collection)this.localSecondaryIndexes.stream().map(LocalSecondaryIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndex ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<LocalSecondaryIndex.Builder> ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Stream.of(localSecondaryIndexes).map(c -> (LocalSecondaryIndex)((LocalSecondaryIndex.Builder)LocalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? (Collection)this.globalSecondaryIndexes.stream().map(GlobalSecondaryIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndex ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (GlobalSecondaryIndex)((GlobalSecondaryIndex.Builder)GlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public final String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return this.streamSpecification != null ? this.streamSpecification.toBuilder() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        public final SSESpecification.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTableRequest> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... var1);

        public Builder tableName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> var1);

        public Builder localSecondaryIndexes(LocalSecondaryIndex ... var1);

        public Builder localSecondaryIndexes(Consumer<LocalSecondaryIndex.Builder> ... var1);

        public Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexes(GlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder> ... var1);

        public Builder billingMode(String var1);

        public Builder billingMode(BillingMode var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder streamSpecification(StreamSpecification var1);

        default public Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return this.streamSpecification((StreamSpecification)((StreamSpecification.Builder)StreamSpecification.builder().applyMutation(streamSpecification)).build());
        }

        public Builder sseSpecification(SSESpecification var1);

        default public Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return this.sseSpecification((SSESpecification)((SSESpecification.Builder)SSESpecification.builder().applyMutation(sseSpecification)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

