/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ReplicaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(ReplicaDescription.getter(ReplicaDescription::regionName)).setter(ReplicaDescription.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatus").getter(ReplicaDescription.getter(ReplicaDescription::replicaStatusAsString)).setter(ReplicaDescription.setter(Builder::replicaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatusDescription").getter(ReplicaDescription.getter(ReplicaDescription::replicaStatusDescription)).setter(ReplicaDescription.setter(Builder::replicaStatusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusDescription").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatusPercentProgress").getter(ReplicaDescription.getter(ReplicaDescription::replicaStatusPercentProgress)).setter(ReplicaDescription.setter(Builder::replicaStatusPercentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusPercentProgress").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSMasterKeyId").getter(ReplicaDescription.getter(ReplicaDescription::kmsMasterKeyId)).setter(ReplicaDescription.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()}).build();
    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(ReplicaDescription.getter(ReplicaDescription::provisionedThroughputOverride)).setter(ReplicaDescription.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndexDescription>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(ReplicaDescription.getter(ReplicaDescription::globalSecondaryIndexes)).setter(ReplicaDescription.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndexDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, REPLICA_STATUS_FIELD, REPLICA_STATUS_DESCRIPTION_FIELD, REPLICA_STATUS_PERCENT_PROGRESS_FIELD, KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String replicaStatus;
    private final String replicaStatusDescription;
    private final String replicaStatusPercentProgress;
    private final String kmsMasterKeyId;
    private final ProvisionedThroughputOverride provisionedThroughputOverride;
    private final List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes;

    private ReplicaDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaStatusDescription = builder.replicaStatusDescription;
        this.replicaStatusPercentProgress = builder.replicaStatusPercentProgress;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
    }

    public String regionName() {
        return this.regionName;
    }

    public ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(this.replicaStatus);
    }

    public String replicaStatusAsString() {
        return this.replicaStatus;
    }

    public String replicaStatusDescription() {
        return this.replicaStatusDescription;
    }

    public String replicaStatusPercentProgress() {
        return this.replicaStatusPercentProgress;
    }

    public String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public ProvisionedThroughputOverride provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusPercentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaDescription)) {
            return false;
        }
        ReplicaDescription other = (ReplicaDescription)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.replicaStatusAsString(), other.replicaStatusAsString()) && Objects.equals(this.replicaStatusDescription(), other.replicaStatusDescription()) && Objects.equals(this.replicaStatusPercentProgress(), other.replicaStatusPercentProgress()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaDescription").add("RegionName", (Object)this.regionName()).add("ReplicaStatus", (Object)this.replicaStatusAsString()).add("ReplicaStatusDescription", (Object)this.replicaStatusDescription()).add("ReplicaStatusPercentProgress", (Object)this.replicaStatusPercentProgress()).add("KMSMasterKeyId", (Object)this.kmsMasterKeyId()).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusAsString()));
            }
            case "ReplicaStatusDescription": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusDescription()));
            }
            case "ReplicaStatusPercentProgress": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusPercentProgress()));
            }
            case "KMSMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaDescription, T> g) {
        return obj -> g.apply((ReplicaDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String replicaStatus;
        private String replicaStatusDescription;
        private String replicaStatusPercentProgress;
        private String kmsMasterKeyId;
        private ProvisionedThroughputOverride provisionedThroughputOverride;
        private List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaDescription model) {
            this.regionName(model.regionName);
            this.replicaStatus(model.replicaStatus);
            this.replicaStatusDescription(model.replicaStatusDescription);
            this.replicaStatusPercentProgress(model.replicaStatusPercentProgress);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getReplicaStatus() {
            return this.replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus == null ? null : replicaStatus.toString());
            return this;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        public final String getReplicaStatusDescription() {
            return this.replicaStatusDescription;
        }

        @Override
        public final Builder replicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
            return this;
        }

        public final void setReplicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
        }

        public final String getReplicaStatusPercentProgress() {
            return this.replicaStatusPercentProgress;
        }

        @Override
        public final Builder replicaStatusPercentProgress(String replicaStatusPercentProgress) {
            this.replicaStatusPercentProgress = replicaStatusPercentProgress;
            return this;
        }

        public final void setReplicaStatusPercentProgress(String replicaStatusPercentProgress) {
            this.replicaStatusPercentProgress = replicaStatusPercentProgress;
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        public final Collection<ReplicaGlobalSecondaryIndexDescription.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? (Collection)this.globalSecondaryIndexes.stream().map(ReplicaGlobalSecondaryIndexDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndexDescription.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (ReplicaGlobalSecondaryIndexDescription)((ReplicaGlobalSecondaryIndexDescription.Builder)ReplicaGlobalSecondaryIndexDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexDescriptionListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public ReplicaDescription build() {
            return new ReplicaDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaDescription> {
        public Builder regionName(String var1);

        public Builder replicaStatus(String var1);

        public Builder replicaStatus(ReplicaStatus var1);

        public Builder replicaStatusDescription(String var1);

        public Builder replicaStatusPercentProgress(String var1);

        public Builder kmsMasterKeyId(String var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughputOverride var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughputOverride)((ProvisionedThroughputOverride.Builder)ProvisionedThroughputOverride.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription> var1);

        public Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexDescription ... var1);

        public Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndexDescription.Builder> ... var1);
    }
}

