/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemResponseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactGetItemsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, TransactGetItemsResponse> {
    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TransactGetItemsResponse.getter(TransactGetItemsResponse::consumedCapacity)).setter(TransactGetItemsResponse.setter(Builder::consumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ItemResponse>> RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TransactGetItemsResponse.getter(TransactGetItemsResponse::responses)).setter(TransactGetItemsResponse.setter(Builder::responses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMED_CAPACITY_FIELD, RESPONSES_FIELD));
    private final List<ConsumedCapacity> consumedCapacity;
    private final List<ItemResponse> responses;

    private TransactGetItemsResponse(BuilderImpl builder) {
        super(builder);
        this.consumedCapacity = builder.consumedCapacity;
        this.responses = builder.responses;
    }

    public boolean hasConsumedCapacity() {
        return this.consumedCapacity != null && !(this.consumedCapacity instanceof SdkAutoConstructList);
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public boolean hasResponses() {
        return this.responses != null && !(this.responses instanceof SdkAutoConstructList);
    }

    public List<ItemResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.responses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactGetItemsResponse)) {
            return false;
        }
        TransactGetItemsResponse other = (TransactGetItemsResponse)((Object)obj);
        return Objects.equals(this.consumedCapacity(), other.consumedCapacity()) && Objects.equals(this.responses(), other.responses());
    }

    public String toString() {
        return ToString.builder((String)"TransactGetItemsResponse").add("ConsumedCapacity", this.consumedCapacity()).add("Responses", this.responses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
            case "Responses": {
                return Optional.ofNullable(clazz.cast(this.responses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactGetItemsResponse, T> g) {
        return obj -> g.apply((TransactGetItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();
        private List<ItemResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransactGetItemsResponse model) {
            super(model);
            this.consumedCapacity(model.consumedCapacity);
            this.responses(model.responses);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            return this.consumedCapacity != null ? (Collection)this.consumedCapacity.stream().map(ConsumedCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... consumedCapacity) {
            this.consumedCapacity(Stream.of(consumedCapacity).map(c -> (ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        public final Collection<ItemResponse.Builder> getResponses() {
            return this.responses != null ? (Collection)this.responses.stream().map(ItemResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responses(Collection<ItemResponse> responses) {
            this.responses = ItemResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(ItemResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<ItemResponse.Builder> ... responses) {
            this.responses(Stream.of(responses).map(c -> (ItemResponse)((ItemResponse.Builder)ItemResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResponses(Collection<ItemResponse.BuilderImpl> responses) {
            this.responses = ItemResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public TransactGetItemsResponse build() {
            return new TransactGetItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TransactGetItemsResponse> {
        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);

        public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... var1);

        public Builder responses(Collection<ItemResponse> var1);

        public Builder responses(ItemResponse ... var1);

        public Builder responses(Consumer<ItemResponse.Builder> ... var1);
    }
}

