/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

public class ListTablesIterable
implements SdkIterable<ListTablesResponse> {
    private final DynamoDbClient client;
    private final ListTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTablesIterable(DynamoDbClient client, ListTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTablesResponseFetcher();
    }

    public Iterator<ListTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> tableNames() {
        Function<ListTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableNames() != null) {
                return response.tableNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTablesResponseFetcher
    implements SyncPageFetcher<ListTablesResponse> {
        private ListTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.lastEvaluatedTableName());
        }

        public ListTablesResponse nextPage(ListTablesResponse previousPage) {
            if (previousPage == null) {
                return ListTablesIterable.this.client.listTables(ListTablesIterable.this.firstRequest);
            }
            return ListTablesIterable.this.client.listTables((ListTablesRequest)((Object)ListTablesIterable.this.firstRequest.toBuilder().exclusiveStartTableName(previousPage.lastEvaluatedTableName()).build()));
        }
    }
}

