/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;

@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
class DynamoDbAsyncEndpointDiscoveryCacheLoader implements EndpointDiscoveryCacheLoader {
    private final DynamoDbAsyncClient client;

    DynamoDbAsyncEndpointDiscoveryCacheLoader(DynamoDbAsyncClient client) {
        this.client = client;
    }

    public static DynamoDbAsyncEndpointDiscoveryCacheLoader create(DynamoDbAsyncClient client) {
        return new DynamoDbAsyncEndpointDiscoveryCacheLoader(client);
    }

    @Override
    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest endpointDiscoveryRequest) {
        return client
                .describeEndpoints(software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest.builder().build())
                .thenApply(
                        r -> {
                            Endpoint endpoint = r.endpoints().get(0);
                            return EndpointDiscoveryEndpoint.builder()
                                    .endpoint(toUri(endpoint.address(), endpointDiscoveryRequest.defaultEndpoint()))
                                    .expirationTime(Instant.now().plus(endpoint.cachePeriodInMinutes(), ChronoUnit.MINUTES))
                                    .build();
                        });
    }
}
