/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ReplicaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaAutoScalingDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaAutoScalingDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicaAutoScalingDescription.getter(ReplicaAutoScalingDescription::regionName)).setter(ReplicaAutoScalingDescription.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndexAutoScalingDescription>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReplicaAutoScalingDescription.getter(ReplicaAutoScalingDescription::globalSecondaryIndexes)).setter(ReplicaAutoScalingDescription.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndexAutoScalingDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReplicaAutoScalingDescription.getter(ReplicaAutoScalingDescription::replicaProvisionedReadCapacityAutoScalingSettings)).setter(ReplicaAutoScalingDescription.setter(Builder::replicaProvisionedReadCapacityAutoScalingSettings)).constructor(AutoScalingSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedReadCapacityAutoScalingSettings").build()}).build();
    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReplicaAutoScalingDescription.getter(ReplicaAutoScalingDescription::replicaProvisionedWriteCapacityAutoScalingSettings)).setter(ReplicaAutoScalingDescription.setter(Builder::replicaProvisionedWriteCapacityAutoScalingSettings)).constructor(AutoScalingSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedWriteCapacityAutoScalingSettings").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicaAutoScalingDescription.getter(ReplicaAutoScalingDescription::replicaStatusAsString)).setter(ReplicaAutoScalingDescription.setter(Builder::replicaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, REPLICA_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final List<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes;
    private final AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;
    private final AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;
    private final String replicaStatus;

    private ReplicaAutoScalingDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.replicaProvisionedReadCapacityAutoScalingSettings = builder.replicaProvisionedReadCapacityAutoScalingSettings;
        this.replicaProvisionedWriteCapacityAutoScalingSettings = builder.replicaProvisionedWriteCapacityAutoScalingSettings;
        this.replicaStatus = builder.replicaStatus;
    }

    public String regionName() {
        return this.regionName;
    }

    public boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public List<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings() {
        return this.replicaProvisionedReadCapacityAutoScalingSettings;
    }

    public AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings() {
        return this.replicaProvisionedWriteCapacityAutoScalingSettings;
    }

    public ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(this.replicaStatus);
    }

    public String replicaStatusAsString() {
        return this.replicaStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedReadCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedWriteCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaAutoScalingDescription)) {
            return false;
        }
        ReplicaAutoScalingDescription other = (ReplicaAutoScalingDescription)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.replicaProvisionedReadCapacityAutoScalingSettings(), other.replicaProvisionedReadCapacityAutoScalingSettings()) && Objects.equals(this.replicaProvisionedWriteCapacityAutoScalingSettings(), other.replicaProvisionedWriteCapacityAutoScalingSettings()) && Objects.equals(this.replicaStatusAsString(), other.replicaStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaAutoScalingDescription").add("RegionName", (Object)this.regionName()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).add("ReplicaProvisionedReadCapacityAutoScalingSettings", (Object)this.replicaProvisionedReadCapacityAutoScalingSettings()).add("ReplicaProvisionedWriteCapacityAutoScalingSettings", (Object)this.replicaProvisionedWriteCapacityAutoScalingSettings()).add("ReplicaStatus", (Object)this.replicaStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "ReplicaProvisionedReadCapacityAutoScalingSettings": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedReadCapacityAutoScalingSettings()));
            }
            case "ReplicaProvisionedWriteCapacityAutoScalingSettings": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedWriteCapacityAutoScalingSettings()));
            }
            case "ReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaAutoScalingDescription, T> g) {
        return obj -> g.apply((ReplicaAutoScalingDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private List<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;
        private AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;
        private String replicaStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaAutoScalingDescription model) {
            this.regionName(model.regionName);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.replicaProvisionedReadCapacityAutoScalingSettings(model.replicaProvisionedReadCapacityAutoScalingSettings);
            this.replicaProvisionedWriteCapacityAutoScalingSettings(model.replicaProvisionedWriteCapacityAutoScalingSettings);
            this.replicaStatus(model.replicaStatus);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final Collection<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? (Collection)this.globalSecondaryIndexes.stream().map(ReplicaGlobalSecondaryIndexAutoScalingDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexAutoScalingDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexAutoScalingDescription ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (ReplicaGlobalSecondaryIndexAutoScalingDescription)((ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder)ReplicaGlobalSecondaryIndexAutoScalingDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexAutoScalingDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexAutoScalingDescriptionListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedReadCapacityAutoScalingSettings() {
            return this.replicaProvisionedReadCapacityAutoScalingSettings != null ? this.replicaProvisionedReadCapacityAutoScalingSettings.toBuilder() : null;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription.BuilderImpl replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings != null ? replicaProvisionedReadCapacityAutoScalingSettings.build() : null;
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedWriteCapacityAutoScalingSettings() {
            return this.replicaProvisionedWriteCapacityAutoScalingSettings != null ? this.replicaProvisionedWriteCapacityAutoScalingSettings.toBuilder() : null;
        }

        @Override
        public final Builder replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings;
            return this;
        }

        public final void setReplicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription.BuilderImpl replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings != null ? replicaProvisionedWriteCapacityAutoScalingSettings.build() : null;
        }

        public final String getReplicaStatusAsString() {
            return this.replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus == null ? null : replicaStatus.toString());
            return this;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        public ReplicaAutoScalingDescription build() {
            return new ReplicaAutoScalingDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaAutoScalingDescription> {
        public Builder regionName(String var1);

        public Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexAutoScalingDescription> var1);

        public Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexAutoScalingDescription ... var1);

        public Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder> ... var1);

        public Builder replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription var1);

        default public Builder replicaProvisionedReadCapacityAutoScalingSettings(Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedReadCapacityAutoScalingSettings) {
            return this.replicaProvisionedReadCapacityAutoScalingSettings((AutoScalingSettingsDescription)((AutoScalingSettingsDescription.Builder)AutoScalingSettingsDescription.builder().applyMutation(replicaProvisionedReadCapacityAutoScalingSettings)).build());
        }

        public Builder replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription var1);

        default public Builder replicaProvisionedWriteCapacityAutoScalingSettings(Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedWriteCapacityAutoScalingSettings) {
            return this.replicaProvisionedWriteCapacityAutoScalingSettings((AutoScalingSettingsDescription)((AutoScalingSettingsDescription.Builder)AutoScalingSettingsDescription.builder().applyMutation(replicaProvisionedWriteCapacityAutoScalingSettings)).build());
        }

        public Builder replicaStatus(String var1);

        public Builder replicaStatus(ReplicaStatus var1);
    }
}

