/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGlobalTablesResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ListGlobalTablesResponse.Builder, ListGlobalTablesResponse> {
    private static final SdkField<List<GlobalTable>> GLOBAL_TABLES_FIELD = SdkField
            .<List<GlobalTable>> builder(MarshallingType.LIST)
            .getter(getter(ListGlobalTablesResponse::globalTables))
            .setter(setter(Builder::globalTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_EVALUATED_GLOBAL_TABLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListGlobalTablesResponse::lastEvaluatedGlobalTableName))
            .setter(setter(Builder::lastEvaluatedGlobalTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedGlobalTableName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLES_FIELD,
            LAST_EVALUATED_GLOBAL_TABLE_NAME_FIELD));

    private final List<GlobalTable> globalTables;

    private final String lastEvaluatedGlobalTableName;

    private ListGlobalTablesResponse(BuilderImpl builder) {
        super(builder);
        this.globalTables = builder.globalTables;
        this.lastEvaluatedGlobalTableName = builder.lastEvaluatedGlobalTableName;
    }

    /**
     * Returns true if the GlobalTables property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGlobalTables() {
        return globalTables != null && !(globalTables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of global table names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalTables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of global table names.
     */
    public List<GlobalTable> globalTables() {
        return globalTables;
    }

    /**
     * <p>
     * Last evaluated global table name.
     * </p>
     * 
     * @return Last evaluated global table name.
     */
    public String lastEvaluatedGlobalTableName() {
        return lastEvaluatedGlobalTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalTables());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedGlobalTableName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGlobalTablesResponse)) {
            return false;
        }
        ListGlobalTablesResponse other = (ListGlobalTablesResponse) obj;
        return Objects.equals(globalTables(), other.globalTables())
                && Objects.equals(lastEvaluatedGlobalTableName(), other.lastEvaluatedGlobalTableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListGlobalTablesResponse").add("GlobalTables", globalTables())
                .add("LastEvaluatedGlobalTableName", lastEvaluatedGlobalTableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalTables":
            return Optional.ofNullable(clazz.cast(globalTables()));
        case "LastEvaluatedGlobalTableName":
            return Optional.ofNullable(clazz.cast(lastEvaluatedGlobalTableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGlobalTablesResponse, T> g) {
        return obj -> g.apply((ListGlobalTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGlobalTablesResponse> {
        /**
         * <p>
         * List of global table names.
         * </p>
         * 
         * @param globalTables
         *        List of global table names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTables(Collection<GlobalTable> globalTables);

        /**
         * <p>
         * List of global table names.
         * </p>
         * 
         * @param globalTables
         *        List of global table names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTables(GlobalTable... globalTables);

        /**
         * <p>
         * List of global table names.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlobalTable>.Builder} avoiding the need to
         * create one manually via {@link List<GlobalTable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalTable>.Builder#build()} is called immediately and its
         * result is passed to {@link #globalTables(List<GlobalTable>)}.
         * 
         * @param globalTables
         *        a consumer that will call methods on {@link List<GlobalTable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalTables(List<GlobalTable>)
         */
        Builder globalTables(Consumer<GlobalTable.Builder>... globalTables);

        /**
         * <p>
         * Last evaluated global table name.
         * </p>
         * 
         * @param lastEvaluatedGlobalTableName
         *        Last evaluated global table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedGlobalTableName(String lastEvaluatedGlobalTableName);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<GlobalTable> globalTables = DefaultSdkAutoConstructList.getInstance();

        private String lastEvaluatedGlobalTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGlobalTablesResponse model) {
            super(model);
            globalTables(model.globalTables);
            lastEvaluatedGlobalTableName(model.lastEvaluatedGlobalTableName);
        }

        public final Collection<GlobalTable.Builder> getGlobalTables() {
            return globalTables != null ? globalTables.stream().map(GlobalTable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalTables(Collection<GlobalTable> globalTables) {
            this.globalTables = GlobalTableListCopier.copy(globalTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTables(GlobalTable... globalTables) {
            globalTables(Arrays.asList(globalTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTables(Consumer<GlobalTable.Builder>... globalTables) {
            globalTables(Stream.of(globalTables).map(c -> GlobalTable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalTables(Collection<GlobalTable.BuilderImpl> globalTables) {
            this.globalTables = GlobalTableListCopier.copyFromBuilder(globalTables);
        }

        public final String getLastEvaluatedGlobalTableName() {
            return lastEvaluatedGlobalTableName;
        }

        @Override
        public final Builder lastEvaluatedGlobalTableName(String lastEvaluatedGlobalTableName) {
            this.lastEvaluatedGlobalTableName = lastEvaluatedGlobalTableName;
            return this;
        }

        public final void setLastEvaluatedGlobalTableName(String lastEvaluatedGlobalTableName) {
            this.lastEvaluatedGlobalTableName = lastEvaluatedGlobalTableName;
        }

        @Override
        public ListGlobalTablesResponse build() {
            return new ListGlobalTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
