/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchWriteItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchWriteItemResponse extends DynamoDbResponse implements
        ToCopyableBuilder<BatchWriteItemResponse.Builder, BatchWriteItemResponse> {
    private static final SdkField<Map<String, List<WriteRequest>>> UNPROCESSED_ITEMS_FIELD = SdkField
            .<Map<String, List<WriteRequest>>> builder(MarshallingType.MAP)
            .getter(getter(BatchWriteItemResponse::unprocessedItems))
            .setter(setter(Builder::unprocessedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<WriteRequest>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<WriteRequest> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(WriteRequest::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<ItemCollectionMetrics>>> ITEM_COLLECTION_METRICS_FIELD = SdkField
            .<Map<String, List<ItemCollectionMetrics>>> builder(MarshallingType.MAP)
            .getter(getter(BatchWriteItemResponse::itemCollectionMetrics))
            .setter(setter(Builder::itemCollectionMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCollectionMetrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ItemCollectionMetrics>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ItemCollectionMetrics> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(ItemCollectionMetrics::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField
            .<List<ConsumedCapacity>> builder(MarshallingType.LIST)
            .getter(getter(BatchWriteItemResponse::consumedCapacity))
            .setter(setter(Builder::consumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConsumedCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConsumedCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_ITEMS_FIELD,
            ITEM_COLLECTION_METRICS_FIELD, CONSUMED_CAPACITY_FIELD));

    private final Map<String, List<WriteRequest>> unprocessedItems;

    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

    private final List<ConsumedCapacity> consumedCapacity;

    private BatchWriteItemResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedItems = builder.unprocessedItems;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * Returns true if the UnprocessedItems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUnprocessedItems() {
        return unprocessedItems != null && !(unprocessedItems instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of tables and requests against those tables that were not processed. The <code>UnprocessedItems</code>
     * value is in the same form as <code>RequestItems</code>, so you can provide this value directly to a subsequent
     * <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the Request
     * Parameters section.
     * </p>
     * <p>
     * Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of operations to
     * perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be
     * deleted is identified by a <code>Key</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map
     * consists of an attribute name and an attribute value.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is
     * identified by an <code>Item</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name
     * and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths
     * greater than zero; and set type attributes must not be empty. Requests that contain empty values will be rejected
     * with a <code>ValidationException</code> exception.
     * </p>
     * <p>
     * If you specify any attributes that are part of an index key, then the data types for those attributes must match
     * those of the schema in the table's attribute definition.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code> map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of tables and requests against those tables that were not processed. The
     *         <code>UnprocessedItems</code> value is in the same form as <code>RequestItems</code>, so you can provide
     *         this value directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
     *         <code>RequestItems</code> in the Request Parameters section.</p>
     *         <p>
     *         Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of
     *         operations to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item
     *         to be deleted is identified by a <code>Key</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in
     *         this map consists of an attribute name and an attribute value.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be
     *         put is identified by an <code>Item</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
     *         name and an attribute value. Attribute values must not be null; string and binary type attributes must
     *         have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty
     *         values will be rejected with a <code>ValidationException</code> exception.
     *         </p>
     *         <p>
     *         If you specify any attributes that are part of an index key, then the data types for those attributes
     *         must match those of the schema in the table's attribute definition.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code>
     *         map.
     */
    public Map<String, List<WriteRequest>> unprocessedItems() {
        return unprocessedItems;
    }

    /**
     * Returns true if the ItemCollectionMetrics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasItemCollectionMetrics() {
        return itemCollectionMetrics != null && !(itemCollectionMetrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information about any
     * item collections that were affected by individual <code>DeleteItem</code> or <code>PutItem</code> operations.
     * </p>
     * <p>
     * Each entry consists of the following subelements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     * partition key value of the item.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SizeEstimateRangeGB</code> - An estimate of item collection size, expressed in GB. This is a two-element
     * array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the
     * items in the table, plus the size of all attributes projected into all of the local secondary indexes on the
     * table. Use this estimate to measure whether a local secondary index is approaching its size limit.
     * </p>
     * <p>
     * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItemCollectionMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information
     *         about any item collections that were affected by individual <code>DeleteItem</code> or
     *         <code>PutItem</code> operations.</p>
     *         <p>
     *         Each entry consists of the following subelements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     *         partition key value of the item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SizeEstimateRangeGB</code> - An estimate of item collection size, expressed in GB. This is a
     *         two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
     *         size of all the items in the table, plus the size of all attributes projected into all of the local
     *         secondary indexes on the table. Use this estimate to measure whether a local secondary index is
     *         approaching its size limit.
     *         </p>
     *         <p>
     *         The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
     *         estimate.
     *         </p>
     *         </li>
     */
    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return itemCollectionMetrics;
    }

    /**
     * Returns true if the ConsumedCapacity property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConsumedCapacity() {
        return consumedCapacity != null && !(consumedCapacity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity units consumed by the entire <code>BatchWriteItem</code> operation.
     * </p>
     * <p>
     * Each element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TableName</code> - The table that consumed the provisioned throughput.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CapacityUnits</code> - The total number of capacity units consumed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConsumedCapacity()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p>
     *         <p>
     *         Each element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TableName</code> - The table that consumed the provisioned throughput.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CapacityUnits</code> - The total number of capacity units consumed.
     *         </p>
     *         </li>
     */
    public List<ConsumedCapacity> consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedItems());
        hashCode = 31 * hashCode + Objects.hashCode(itemCollectionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemResponse)) {
            return false;
        }
        BatchWriteItemResponse other = (BatchWriteItemResponse) obj;
        return Objects.equals(unprocessedItems(), other.unprocessedItems())
                && Objects.equals(itemCollectionMetrics(), other.itemCollectionMetrics())
                && Objects.equals(consumedCapacity(), other.consumedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchWriteItemResponse").add("UnprocessedItems", unprocessedItems())
                .add("ItemCollectionMetrics", itemCollectionMetrics()).add("ConsumedCapacity", consumedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnprocessedItems":
            return Optional.ofNullable(clazz.cast(unprocessedItems()));
        case "ItemCollectionMetrics":
            return Optional.ofNullable(clazz.cast(itemCollectionMetrics()));
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteItemResponse, T> g) {
        return obj -> g.apply((BatchWriteItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchWriteItemResponse> {
        /**
         * <p>
         * A map of tables and requests against those tables that were not processed. The <code>UnprocessedItems</code>
         * value is in the same form as <code>RequestItems</code>, so you can provide this value directly to a
         * subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the
         * Request Parameters section.
         * </p>
         * <p>
         * Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of operations
         * to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to
         * be deleted is identified by a <code>Key</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this
         * map consists of an attribute name and an attribute value.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put
         * is identified by an <code>Item</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
         * name and an attribute value. Attribute values must not be null; string and binary type attributes must have
         * lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values will
         * be rejected with a <code>ValidationException</code> exception.
         * </p>
         * <p>
         * If you specify any attributes that are part of an index key, then the data types for those attributes must
         * match those of the schema in the table's attribute definition.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code>
         * map.
         * </p>
         * 
         * @param unprocessedItems
         *        A map of tables and requests against those tables that were not processed. The
         *        <code>UnprocessedItems</code> value is in the same form as <code>RequestItems</code>, so you can
         *        provide this value directly to a subsequent <code>BatchGetItem</code> operation. For more information,
         *        see <code>RequestItems</code> in the Request Parameters section.</p>
         *        <p>
         *        Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of
         *        operations to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The
         *        item to be deleted is identified by a <code>Key</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry
         *        in this map consists of an attribute name and an attribute value.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to
         *        be put is identified by an <code>Item</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an
         *        attribute name and an attribute value. Attribute values must not be null; string and binary type
         *        attributes must have lengths greater than zero; and set type attributes must not be empty. Requests
         *        that contain empty values will be rejected with a <code>ValidationException</code> exception.
         *        </p>
         *        <p>
         *        If you specify any attributes that are part of an index key, then the data types for those attributes
         *        must match those of the schema in the table's attribute definition.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        If there are no unprocessed items remaining, the response contains an empty
         *        <code>UnprocessedItems</code> map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems);

        /**
         * <p>
         * A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information about
         * any item collections that were affected by individual <code>DeleteItem</code> or <code>PutItem</code>
         * operations.
         * </p>
         * <p>
         * Each entry consists of the following subelements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
         * partition key value of the item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeEstimateRangeGB</code> - An estimate of item collection size, expressed in GB. This is a
         * two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
         * size of all the items in the table, plus the size of all attributes projected into all of the local secondary
         * indexes on the table. Use this estimate to measure whether a local secondary index is approaching its size
         * limit.
         * </p>
         * <p>
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
         * estimate.
         * </p>
         * </li>
         * </ul>
         * 
         * @param itemCollectionMetrics
         *        A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information
         *        about any item collections that were affected by individual <code>DeleteItem</code> or
         *        <code>PutItem</code> operations.</p>
         *        <p>
         *        Each entry consists of the following subelements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as
         *        the partition key value of the item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SizeEstimateRangeGB</code> - An estimate of item collection size, expressed in GB. This is a
         *        two-element array containing a lower bound and an upper bound for the estimate. The estimate includes
         *        the size of all the items in the table, plus the size of all attributes projected into all of the
         *        local secondary indexes on the table. Use this estimate to measure whether a local secondary index is
         *        approaching its size limit.
         *        </p>
         *        <p>
         *        The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of
         *        the estimate.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics);

        /**
         * <p>
         * The capacity units consumed by the entire <code>BatchWriteItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the entire <code>BatchWriteItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity... consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the entire <code>BatchWriteItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<ConsumedCapacity>.Builder} avoiding the
         * need to create one manually via {@link List<ConsumedCapacity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConsumedCapacity>.Builder#build()} is called immediately and
         * its result is passed to {@link #consumedCapacity(List<ConsumedCapacity>)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link List<ConsumedCapacity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(List<ConsumedCapacity>)
         */
        Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private Map<String, List<WriteRequest>> unprocessedItems = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics = DefaultSdkAutoConstructMap.getInstance();

        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemResponse model) {
            super(model);
            unprocessedItems(model.unprocessedItems);
            itemCollectionMetrics(model.itemCollectionMetrics);
            consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getUnprocessedItems() {
            return unprocessedItems;
        }

        @Override
        public final Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
            return this;
        }

        public final void setUnprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
        }

        public final Map<String, ? extends Collection<ItemCollectionMetrics>> getItemCollectionMetrics() {
            return itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.stream().map(ConsumedCapacity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity... consumedCapacity) {
            consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity) {
            consumedCapacity(Stream.of(consumedCapacity).map(c -> ConsumedCapacity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        @Override
        public BatchWriteItemResponse build() {
            return new BatchWriteItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
