/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteItemRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<Map> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPECTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expected").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITIONALOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionalOperator").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnValues").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNITEMCOLLECTIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnItemCollectionMetrics").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITIONEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionExpression").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeNames").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeValues").isBinary(false).build();
    private static final DeleteItemRequestModelMarshaller INSTANCE = new DeleteItemRequestModelMarshaller();

    private DeleteItemRequestModelMarshaller() {
    }

    public static DeleteItemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteItemRequest deleteItemRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)deleteItemRequest), (String)"deleteItemRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deleteItemRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(deleteItemRequest.key(), KEY_BINDING);
            protocolMarshaller.marshall(deleteItemRequest.expected(), EXPECTED_BINDING);
            protocolMarshaller.marshall((Object)deleteItemRequest.conditionalOperatorAsString(), CONDITIONALOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)deleteItemRequest.returnValuesAsString(), RETURNVALUES_BINDING);
            protocolMarshaller.marshall((Object)deleteItemRequest.returnConsumedCapacityAsString(), RETURNCONSUMEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)deleteItemRequest.returnItemCollectionMetricsAsString(), RETURNITEMCOLLECTIONMETRICS_BINDING);
            protocolMarshaller.marshall((Object)deleteItemRequest.conditionExpression(), CONDITIONEXPRESSION_BINDING);
            protocolMarshaller.marshall(deleteItemRequest.expressionAttributeNames(), EXPRESSIONATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(deleteItemRequest.expressionAttributeValues(), EXPRESSIONATTRIBUTEVALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

