/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ReplicaStatus;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaSettingsDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaSettingsDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicaSettingsDescription> {
    private final String regionName;
    private final String replicaStatus;
    private final Long replicaProvisionedReadCapacityUnits;
    private final Long replicaProvisionedWriteCapacityUnits;
    private final List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings;

    private ReplicaSettingsDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaProvisionedReadCapacityUnits = builder.replicaProvisionedReadCapacityUnits;
        this.replicaProvisionedWriteCapacityUnits = builder.replicaProvisionedWriteCapacityUnits;
        this.replicaGlobalSecondaryIndexSettings = builder.replicaGlobalSecondaryIndexSettings;
    }

    public String regionName() {
        return this.regionName;
    }

    public ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(this.replicaStatus);
    }

    public String replicaStatusAsString() {
        return this.replicaStatus;
    }

    public Long replicaProvisionedReadCapacityUnits() {
        return this.replicaProvisionedReadCapacityUnits;
    }

    public Long replicaProvisionedWriteCapacityUnits() {
        return this.replicaProvisionedWriteCapacityUnits;
    }

    public List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings() {
        return this.replicaGlobalSecondaryIndexSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaGlobalSecondaryIndexSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSettingsDescription)) {
            return false;
        }
        ReplicaSettingsDescription other = (ReplicaSettingsDescription)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.replicaStatusAsString(), other.replicaStatusAsString()) && Objects.equals(this.replicaProvisionedReadCapacityUnits(), other.replicaProvisionedReadCapacityUnits()) && Objects.equals(this.replicaProvisionedWriteCapacityUnits(), other.replicaProvisionedWriteCapacityUnits()) && Objects.equals(this.replicaGlobalSecondaryIndexSettings(), other.replicaGlobalSecondaryIndexSettings());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaSettingsDescription").add("RegionName", (Object)this.regionName()).add("ReplicaStatus", (Object)this.replicaStatusAsString()).add("ReplicaProvisionedReadCapacityUnits", (Object)this.replicaProvisionedReadCapacityUnits()).add("ReplicaProvisionedWriteCapacityUnits", (Object)this.replicaProvisionedWriteCapacityUnits()).add("ReplicaGlobalSecondaryIndexSettings", this.replicaGlobalSecondaryIndexSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusAsString()));
            }
            case "ReplicaProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedReadCapacityUnits()));
            }
            case "ReplicaProvisionedWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedWriteCapacityUnits()));
            }
            case "ReplicaGlobalSecondaryIndexSettings": {
                return Optional.ofNullable(clazz.cast(this.replicaGlobalSecondaryIndexSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaSettingsDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String replicaStatus;
        private Long replicaProvisionedReadCapacityUnits;
        private Long replicaProvisionedWriteCapacityUnits;
        private List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSettingsDescription model) {
            this.regionName(model.regionName);
            this.replicaStatus(model.replicaStatus);
            this.replicaProvisionedReadCapacityUnits(model.replicaProvisionedReadCapacityUnits);
            this.replicaProvisionedWriteCapacityUnits(model.replicaProvisionedWriteCapacityUnits);
            this.replicaGlobalSecondaryIndexSettings(model.replicaGlobalSecondaryIndexSettings);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getReplicaStatus() {
            return this.replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus.toString());
            return this;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        public final Long getReplicaProvisionedReadCapacityUnits() {
            return this.replicaProvisionedReadCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
        }

        public final Long getReplicaProvisionedWriteCapacityUnits() {
            return this.replicaProvisionedWriteCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
            return this;
        }

        public final void setReplicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
        }

        public final Collection<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> getReplicaGlobalSecondaryIndexSettings() {
            return this.replicaGlobalSecondaryIndexSettings != null ? (Collection)this.replicaGlobalSecondaryIndexSettings.stream().map(ReplicaGlobalSecondaryIndexSettingsDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaGlobalSecondaryIndexSettings(Collection<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier.copy(replicaGlobalSecondaryIndexSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(ReplicaGlobalSecondaryIndexSettingsDescription ... replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings(Arrays.asList(replicaGlobalSecondaryIndexSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> ... replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings(Stream.of(replicaGlobalSecondaryIndexSettings).map(c -> (ReplicaGlobalSecondaryIndexSettingsDescription)((ReplicaGlobalSecondaryIndexSettingsDescription.Builder)ReplicaGlobalSecondaryIndexSettingsDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaGlobalSecondaryIndexSettings(Collection<ReplicaGlobalSecondaryIndexSettingsDescription.BuilderImpl> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier.copyFromBuilder(replicaGlobalSecondaryIndexSettings);
        }

        public ReplicaSettingsDescription build() {
            return new ReplicaSettingsDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicaSettingsDescription> {
        public Builder regionName(String var1);

        public Builder replicaStatus(String var1);

        public Builder replicaStatus(ReplicaStatus var1);

        public Builder replicaProvisionedReadCapacityUnits(Long var1);

        public Builder replicaProvisionedWriteCapacityUnits(Long var1);

        public Builder replicaGlobalSecondaryIndexSettings(Collection<ReplicaGlobalSecondaryIndexSettingsDescription> var1);

        public Builder replicaGlobalSecondaryIndexSettings(ReplicaGlobalSecondaryIndexSettingsDescription ... var1);

        public Builder replicaGlobalSecondaryIndexSettings(Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> ... var1);
    }
}

