/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalSecondaryIndexAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateGlobalSecondaryIndexActionMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROJECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Projection").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONEDTHROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughput").isBinary(false).build();
    private static final CreateGlobalSecondaryIndexActionMarshaller INSTANCE = new CreateGlobalSecondaryIndexActionMarshaller();

    private CreateGlobalSecondaryIndexActionMarshaller() {
    }

    public static CreateGlobalSecondaryIndexActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateGlobalSecondaryIndexAction createGlobalSecondaryIndexAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)createGlobalSecondaryIndexAction, (String)"createGlobalSecondaryIndexAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createGlobalSecondaryIndexAction.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(createGlobalSecondaryIndexAction.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)createGlobalSecondaryIndexAction.projection(), PROJECTION_BINDING);
            protocolMarshaller.marshall((Object)createGlobalSecondaryIndexAction.provisionedThroughput(), PROVISIONEDTHROUGHPUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

