/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.dynamodb.DynamoDBAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class QueryPublisher
implements SdkPublisher<QueryResponse> {
    private final DynamoDBAsyncClient client;
    private final QueryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryPublisher(DynamoDBAsyncClient client, QueryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryPublisher(DynamoDBAsyncClient client, QueryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Map<String, AttributeValue>> items() {
        Function<QueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new QueryResponseFetcher(), getIterator, this.isLastPage);
    }

    public final QueryPublisher resume(QueryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new QueryPublisher(this.client, (QueryRequest)((Object)this.firstRequest.toBuilder().exclusiveStartKey(lastSuccessfulPage.lastEvaluatedKey()).build()));
        }
        return new QueryPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super QueryResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class QueryResponseFetcher
    implements AsyncPageFetcher<QueryResponse> {
        private QueryResponseFetcher() {
        }

        public boolean hasNextPage(QueryResponse previousPage) {
            return previousPage.lastEvaluatedKey() != null;
        }

        public CompletableFuture<QueryResponse> nextPage(QueryResponse previousPage) {
            if (previousPage == null) {
                return QueryPublisher.this.client.query(QueryPublisher.this.firstRequest);
            }
            return QueryPublisher.this.client.query((QueryRequest)((Object)QueryPublisher.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

