/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetItemResponse
extends DynamoDBResponse
implements ToCopyableBuilder<Builder, GetItemResponse> {
    private final Map<String, AttributeValue> item;
    private final ConsumedCapacity consumedCapacity;

    private GetItemResponse(BuilderImpl builder) {
        super(builder);
        this.item = builder.item;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public Map<String, AttributeValue> item() {
        return this.item;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemResponse)) {
            return false;
        }
        GetItemResponse other = (GetItemResponse)((Object)obj);
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public String toString() {
        return ToString.builder((String)"GetItemResponse").add("Item", this.item()).add("ConsumedCapacity", (Object)this.consumedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.of(clazz.cast(this.item()));
            }
            case "ConsumedCapacity": {
                return Optional.of(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBResponse.BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> item;
        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GetItemResponse model) {
            this.item(model.item);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return this.item != null ? CollectionUtils.mapValues(this.item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = AttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = AttributeMapCopier.copyFromBuilder(item);
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return this.consumedCapacity != null ? this.consumedCapacity.toBuilder() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        public GetItemResponse build() {
            return new GetItemResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDBResponse.Builder,
    CopyableBuilder<Builder, GetItemResponse> {
        public Builder item(Map<String, AttributeValue> var1);

        public Builder consumedCapacity(ConsumedCapacity var1);

        default public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return this.consumedCapacity((ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().apply(consumedCapacity)).build());
        }
    }
}

