/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsClient;

public final class DescribeStreamPaginator
implements SdkIterable<DescribeStreamResponse> {
    private final DynamoDBStreamsClient client;
    private final DescribeStreamRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeStreamPaginator(DynamoDBStreamsClient client, DescribeStreamRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStreamResponseFetcher();
    }

    public Iterator<DescribeStreamResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Shard> shards() {
        Function<DescribeStreamResponse, Iterator> getIterator = response -> response != null ? response.streamDescription().shards().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeStreamResponseFetcher
    implements NextPageFetcher<DescribeStreamResponse> {
        private DescribeStreamResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStreamResponse previousPage) {
            return previousPage.streamDescription().lastEvaluatedShardId() != null;
        }

        public DescribeStreamResponse nextPage(DescribeStreamResponse previousPage) {
            if (previousPage == null) {
                return DescribeStreamPaginator.this.client.describeStream(DescribeStreamPaginator.this.firstRequest);
            }
            return DescribeStreamPaginator.this.client.describeStream((DescribeStreamRequest)((Object)DescribeStreamPaginator.this.firstRequest.toBuilder().exclusiveStartShardId(previousPage.streamDescription().lastEvaluatedShardId()).build()));
        }
    }
}

