/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public final class QueryPaginator
implements SdkIterable<QueryResponse> {
    private final DynamoDBClient client;
    private final QueryRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public QueryPaginator(DynamoDBClient client, QueryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new QueryResponseFetcher();
    }

    public Iterator<QueryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Map<String, AttributeValue>> items() {
        Function<QueryResponse, Iterator> getIterator = response -> response != null ? response.items().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class QueryResponseFetcher
    implements NextPageFetcher<QueryResponse> {
        private QueryResponseFetcher() {
        }

        public boolean hasNextPage(QueryResponse previousPage) {
            return previousPage.lastEvaluatedKey() != null;
        }

        public QueryResponse nextPage(QueryResponse previousPage) {
            if (previousPage == null) {
                return QueryPaginator.this.client.query(QueryPaginator.this.firstRequest);
            }
            return QueryPaginator.this.client.query((QueryRequest)((Object)QueryPaginator.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

