/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.StreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Stream
implements StructuredPojo,
ToCopyableBuilder<Builder, Stream> {
    private final String streamArn;
    private final String tableName;
    private final String streamLabel;

    private Stream(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.tableName = builder.tableName;
        this.streamLabel = builder.streamLabel;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public String tableName() {
        return this.tableName;
    }

    public String streamLabel() {
        return this.streamLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamArn() == null ? 0 : this.streamArn().hashCode());
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.streamLabel() == null ? 0 : this.streamLabel().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream)obj;
        if (other.streamArn() == null ^ this.streamArn() == null) {
            return false;
        }
        if (other.streamArn() != null && !other.streamArn().equals(this.streamArn())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.streamLabel() == null ^ this.streamLabel() == null) {
            return false;
        }
        return other.streamLabel() == null || other.streamLabel().equals(this.streamLabel());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamArn() != null) {
            sb.append("StreamArn: ").append(this.streamArn()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.streamLabel() != null) {
            sb.append("StreamLabel: ").append(this.streamLabel()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.of(clazz.cast(this.streamArn()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "StreamLabel": {
                return Optional.of(clazz.cast(this.streamLabel()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private String tableName;
        private String streamLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            this.streamArn(model.streamArn);
            this.tableName(model.tableName);
            this.streamLabel(model.streamLabel);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getStreamLabel() {
            return this.streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        public Stream build() {
            return new Stream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Stream> {
        public Builder streamArn(String var1);

        public Builder tableName(String var1);

        public Builder streamLabel(String var1);
    }
}

