/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;

@SdkInternalApi
public class StreamSpecificationMarshaller {
    private static final MarshallingInfo<Boolean> STREAMENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamEnabled").build();
    private static final MarshallingInfo<String> STREAMVIEWTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamViewType").build();
    private static final StreamSpecificationMarshaller INSTANCE = new StreamSpecificationMarshaller();

    public static StreamSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamSpecification streamSpecification, ProtocolMarshaller protocolMarshaller) {
        if (streamSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamSpecification.streamEnabled(), STREAMENABLED_BINDING);
            protocolMarshaller.marshall((Object)streamSpecification.streamViewType(), STREAMVIEWTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

