/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.Projection;

public class ProjectionUnmarshaller
implements Unmarshaller<Projection, JsonUnmarshallerContext> {
    private static final ProjectionUnmarshaller INSTANCE = new ProjectionUnmarshaller();

    public Projection unmarshall(JsonUnmarshallerContext context) throws Exception {
        Projection.Builder projectionBuilder = Projection.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ProjectionType", targetDepth)) {
                    context.nextToken();
                    projectionBuilder.projectionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NonKeyAttributes", targetDepth)) {
                    context.nextToken();
                    projectionBuilder.nonKeyAttributes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Projection)projectionBuilder.build();
    }

    public static ProjectionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

