/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueUnmarshaller;

public class ItemCollectionMetricsUnmarshaller
implements Unmarshaller<ItemCollectionMetrics, JsonUnmarshallerContext> {
    private static final ItemCollectionMetricsUnmarshaller INSTANCE = new ItemCollectionMetricsUnmarshaller();

    public ItemCollectionMetrics unmarshall(JsonUnmarshallerContext context) throws Exception {
        ItemCollectionMetrics.Builder itemCollectionMetricsBuilder = ItemCollectionMetrics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ItemCollectionKey", targetDepth)) {
                    context.nextToken();
                    itemCollectionMetricsBuilder.itemCollectionKey(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SizeEstimateRangeGB", targetDepth)) {
                    context.nextToken();
                    itemCollectionMetricsBuilder.sizeEstimateRangeGB(new ListUnmarshaller(context.getUnmarshaller(Double.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ItemCollectionMetrics)itemCollectionMetricsBuilder.build();
    }

    public static ItemCollectionMetricsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

