/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeUpdatesCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateItemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateItemRequest> {
    private final String tableName;
    private final Map<String, AttributeValue> key;
    private final Map<String, AttributeValueUpdate> attributeUpdates;
    private final Map<String, ExpectedAttributeValue> expected;
    private final String conditionalOperator;
    private final String returnValues;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;
    private final String updateExpression;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;

    private UpdateItemRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.key = builder.key;
        this.attributeUpdates = builder.attributeUpdates;
        this.expected = builder.expected;
        this.conditionalOperator = builder.conditionalOperator;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.updateExpression = builder.updateExpression;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    public String tableName() {
        return this.tableName;
    }

    public Map<String, AttributeValue> key() {
        return this.key;
    }

    public Map<String, AttributeValueUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public Map<String, ExpectedAttributeValue> expected() {
        return this.expected;
    }

    public String conditionalOperator() {
        return this.conditionalOperator;
    }

    public String returnValues() {
        return this.returnValues;
    }

    public String returnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public String returnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public String updateExpression() {
        return this.updateExpression;
    }

    public String conditionExpression() {
        return this.conditionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.attributeUpdates() == null ? 0 : this.attributeUpdates().hashCode());
        hashCode = 31 * hashCode + (this.expected() == null ? 0 : this.expected().hashCode());
        hashCode = 31 * hashCode + (this.conditionalOperator() == null ? 0 : this.conditionalOperator().hashCode());
        hashCode = 31 * hashCode + (this.returnValues() == null ? 0 : this.returnValues().hashCode());
        hashCode = 31 * hashCode + (this.returnConsumedCapacity() == null ? 0 : this.returnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.returnItemCollectionMetrics() == null ? 0 : this.returnItemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + (this.updateExpression() == null ? 0 : this.updateExpression().hashCode());
        hashCode = 31 * hashCode + (this.conditionExpression() == null ? 0 : this.conditionExpression().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeNames() == null ? 0 : this.expressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeValues() == null ? 0 : this.expressionAttributeValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateItemRequest)) {
            return false;
        }
        UpdateItemRequest other = (UpdateItemRequest)((Object)obj);
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.attributeUpdates() == null ^ this.attributeUpdates() == null) {
            return false;
        }
        if (other.attributeUpdates() != null && !other.attributeUpdates().equals(this.attributeUpdates())) {
            return false;
        }
        if (other.expected() == null ^ this.expected() == null) {
            return false;
        }
        if (other.expected() != null && !other.expected().equals(this.expected())) {
            return false;
        }
        if (other.conditionalOperator() == null ^ this.conditionalOperator() == null) {
            return false;
        }
        if (other.conditionalOperator() != null && !other.conditionalOperator().equals(this.conditionalOperator())) {
            return false;
        }
        if (other.returnValues() == null ^ this.returnValues() == null) {
            return false;
        }
        if (other.returnValues() != null && !other.returnValues().equals(this.returnValues())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        if (other.returnItemCollectionMetrics() == null ^ this.returnItemCollectionMetrics() == null) {
            return false;
        }
        if (other.returnItemCollectionMetrics() != null && !other.returnItemCollectionMetrics().equals(this.returnItemCollectionMetrics())) {
            return false;
        }
        if (other.updateExpression() == null ^ this.updateExpression() == null) {
            return false;
        }
        if (other.updateExpression() != null && !other.updateExpression().equals(this.updateExpression())) {
            return false;
        }
        if (other.conditionExpression() == null ^ this.conditionExpression() == null) {
            return false;
        }
        if (other.conditionExpression() != null && !other.conditionExpression().equals(this.conditionExpression())) {
            return false;
        }
        if (other.expressionAttributeNames() == null ^ this.expressionAttributeNames() == null) {
            return false;
        }
        if (other.expressionAttributeNames() != null && !other.expressionAttributeNames().equals(this.expressionAttributeNames())) {
            return false;
        }
        if (other.expressionAttributeValues() == null ^ this.expressionAttributeValues() == null) {
            return false;
        }
        return other.expressionAttributeValues() == null || other.expressionAttributeValues().equals(this.expressionAttributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.attributeUpdates() != null) {
            sb.append("AttributeUpdates: ").append(this.attributeUpdates()).append(",");
        }
        if (this.expected() != null) {
            sb.append("Expected: ").append(this.expected()).append(",");
        }
        if (this.conditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(this.conditionalOperator()).append(",");
        }
        if (this.returnValues() != null) {
            sb.append("ReturnValues: ").append(this.returnValues()).append(",");
        }
        if (this.returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacity()).append(",");
        }
        if (this.returnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.returnItemCollectionMetrics()).append(",");
        }
        if (this.updateExpression() != null) {
            sb.append("UpdateExpression: ").append(this.updateExpression()).append(",");
        }
        if (this.conditionExpression() != null) {
            sb.append("ConditionExpression: ").append(this.conditionExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        if (this.expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.expressionAttributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, AttributeValue> key;
        private Map<String, AttributeValueUpdate> attributeUpdates;
        private Map<String, ExpectedAttributeValue> expected;
        private String conditionalOperator;
        private String returnValues;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;
        private String updateExpression;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames;
        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateItemRequest model) {
            this.setTableName(model.tableName);
            this.setKey(model.key);
            this.setAttributeUpdates(model.attributeUpdates);
            this.setExpected(model.expected);
            this.setConditionalOperator(model.conditionalOperator);
            this.setReturnValues(model.returnValues);
            this.setReturnConsumedCapacity(model.returnConsumedCapacity);
            this.setReturnItemCollectionMetrics(model.returnItemCollectionMetrics);
            this.setUpdateExpression(model.updateExpression);
            this.setConditionExpression(model.conditionExpression);
            this.setExpressionAttributeNames(model.expressionAttributeNames);
            this.setExpressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue> getKey() {
            return this.key;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
        }

        public final Map<String, AttributeValueUpdate> getAttributeUpdates() {
            return this.attributeUpdates;
        }

        @Override
        public final Builder attributeUpdates(Map<String, AttributeValueUpdate> attributeUpdates) {
            this.attributeUpdates = AttributeUpdatesCopier.copy(attributeUpdates);
            return this;
        }

        public final void setAttributeUpdates(Map<String, AttributeValueUpdate> attributeUpdates) {
            this.attributeUpdates = AttributeUpdatesCopier.copy(attributeUpdates);
        }

        public final Map<String, ExpectedAttributeValue> getExpected() {
            return this.expected;
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final String getReturnValues() {
            return this.returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues.toString());
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final String getUpdateExpression() {
            return this.updateExpression;
        }

        @Override
        public final Builder updateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
            return this;
        }

        public final void setUpdateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue> getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
        }

        public UpdateItemRequest build() {
            return new UpdateItemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateItemRequest> {
        public Builder tableName(String var1);

        public Builder key(Map<String, AttributeValue> var1);

        public Builder attributeUpdates(Map<String, AttributeValueUpdate> var1);

        public Builder expected(Map<String, ExpectedAttributeValue> var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder returnValues(String var1);

        public Builder returnValues(ReturnValue var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);

        public Builder updateExpression(String var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);
    }
}

