/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.spec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.ScanFilter;
import software.amazon.awssdk.services.dynamodb.document.spec.AbstractCollectionSpec;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.Select;

public class ScanSpec
extends AbstractCollectionSpec<ScanRequest> {
    private Collection<ScanFilter> scanFilters;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;
    private Collection<KeyAttribute> exclusiveStartKey;

    public ScanSpec() {
        super((AmazonWebServiceRequest)ScanRequest.builder().build());
    }

    public Collection<ScanFilter> scanFilters() {
        return this.scanFilters;
    }

    public ScanSpec withScanFilters(ScanFilter ... scanFilters) {
        if (scanFilters == null) {
            this.scanFilters = null;
        } else {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (ScanFilter e : scanFilters) {
                names.add(e.getAttribute());
            }
            if (names.size() != scanFilters.length) {
                throw new IllegalArgumentException("attribute names must not duplicate in the list of scan filters");
            }
            this.scanFilters = Arrays.asList(scanFilters);
        }
        return this;
    }

    public String getConditionalOperator() {
        return ((ScanRequest)((Object)this.getRequest())).conditionalOperator();
    }

    public ScanSpec withConditionalOperator(ConditionalOperator op) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().conditionalOperator(op).build());
        return this;
    }

    public List<String> getAttributesToGet() {
        return ((ScanRequest)((Object)this.getRequest())).attributesToGet();
    }

    public ScanSpec withAttributesToGet(String ... attributes) {
        if (attributes == null) {
            this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().attributesToGet((String[])null).build());
        } else {
            this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().attributesToGet(Arrays.asList(attributes)).build());
        }
        return this;
    }

    public String getFilterExpression() {
        return ((ScanRequest)((Object)this.getRequest())).filterExpression();
    }

    public ScanSpec withFilterExpression(String filterExpression) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().filterExpression(filterExpression).build());
        return this;
    }

    public String getProjectionExpression() {
        return ((ScanRequest)((Object)this.getRequest())).projectionExpression();
    }

    public ScanSpec withProjectionExpression(String projectionExpression) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().projectionExpression(projectionExpression).build());
        return this;
    }

    public Map<String, String> nameMap() {
        return this.nameMap;
    }

    public ScanSpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> valueMap() {
        return this.valueMap;
    }

    public ScanSpec valueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(valueMap));
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((ScanRequest)((Object)this.getRequest())).returnConsumedCapacity();
    }

    public ScanSpec withReturnConsumedCapacity(ReturnConsumedCapacity capacity) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().returnConsumedCapacity(capacity).build());
        return this;
    }

    public String select() {
        return ((ScanRequest)((Object)this.getRequest())).select();
    }

    public ScanSpec withSelect(Select select) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().select(select).build());
        return this;
    }

    public Integer segment() {
        return ((ScanRequest)((Object)this.getRequest())).segment();
    }

    public ScanSpec withSegment(Integer segment) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().segment(segment).build());
        return this;
    }

    public Integer getTotalSegments() {
        return ((ScanRequest)((Object)this.getRequest())).totalSegments();
    }

    public ScanSpec withTotalSegments(Integer totalSegments) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().totalSegments(totalSegments).build());
        return this;
    }

    public Boolean isConsistentRead() {
        return ((ScanRequest)((Object)this.getRequest())).consistentRead();
    }

    public ScanSpec withConsistentRead(Boolean consistentRead) {
        this.setRequest((AmazonWebServiceRequest)((ScanRequest)((Object)this.getRequest())).toBuilder().consistentRead(consistentRead).build());
        return this;
    }

    public Collection<KeyAttribute> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public ScanSpec withExclusiveStartKey(KeyAttribute ... exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : Arrays.asList(exclusiveStartKey);
        return this;
    }

    public ScanSpec withExclusiveStartKey(PrimaryKey exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : exclusiveStartKey.getComponents();
        return this;
    }

    public ScanSpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue));
    }

    public ScanSpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue), new KeyAttribute(rangeKeyName, rangeKeyValue));
    }

    public ScanSpec withMaxResultSize(Integer maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public ScanSpec withMaxResultSize(int maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public ScanSpec withMaxPageSize(Integer maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public ScanSpec withMaxPageSize(int maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public ScanSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }
}

