/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Collection;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.DeleteItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.api.DeleteItemApi;
import software.amazon.awssdk.services.dynamodb.document.internal.AbstractImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.DeleteItemSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;

public class DeleteItemImpl
extends AbstractImpl
implements DeleteItemApi {
    public DeleteItemImpl(DynamoDBClient client, Table table) {
        super(client, table);
    }

    @Override
    public DeleteItemOutcome deleteItem(KeyAttribute ... primaryKeyComponents) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeyComponents));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKey));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKeys, Expected ... expected) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeys).withExpected(expected));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKeys, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeys).withConditionExpression(conditionExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public DeleteItemOutcome deleteItem(DeleteItemSpec spec) {
        return this.doDeleteItem(spec);
    }

    private DeleteItemOutcome doDeleteItem(DeleteItemSpec spec) {
        String tableName = this.getTable().getTableName();
        DeleteItemRequest.Builder requestBuilder = ((DeleteItemRequest)spec.getRequest()).toBuilder().tableName(tableName).key(InternalUtils.toAttributeValueMap(spec.getKeyComponents()));
        Collection<Expected> expected = spec.getExpected();
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(expected);
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.valueMap());
        requestBuilder.expected(expectedMap).expressionAttributeNames(spec.nameMap()).expressionAttributeValues(attrValMap);
        DeleteItemResponse result = this.getClient().deleteItem((DeleteItemRequest)((Object)requestBuilder.build()));
        return new DeleteItemOutcome(result);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue));
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue));
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, Expected ... expected) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue), expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Expected ... expected) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue), conditionExpression, nameMap, valueMap);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), conditionExpression, nameMap, valueMap);
    }
}

