/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.transform.AttributeDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeDefinition> {
    private final String attributeName;
    private final String attributeType;

    private AttributeDefinition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeType = builder.attributeType;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String attributeType() {
        return this.attributeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        hashCode = 31 * hashCode + (this.attributeType() == null ? 0 : this.attributeType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDefinition)) {
            return false;
        }
        AttributeDefinition other = (AttributeDefinition)obj;
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeType() == null ^ this.attributeType() == null) {
            return false;
        }
        return other.attributeType() == null || other.attributeType().equals(this.attributeType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.attributeType() != null) {
            sb.append("AttributeType: ").append(this.attributeType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String attributeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeDefinition model) {
            this.setAttributeName(model.attributeName);
            this.setAttributeType(model.attributeType);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(ScalarAttributeType attributeType) {
            this.attributeType(attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public AttributeDefinition build() {
            return new AttributeDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeDefinition> {
        public Builder attributeName(String var1);

        public Builder attributeType(String var1);

        public Builder attributeType(ScalarAttributeType var1);
    }
}

