/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.spec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.services.dynamodb.document.AttributeUpdate;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.spec.AbstractSpecWithPrimaryKey;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class UpdateItemSpec
extends AbstractSpecWithPrimaryKey<UpdateItemRequest> {
    private List<AttributeUpdate> attributes;
    private Collection<Expected> expected;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;

    public UpdateItemSpec() {
        super((AmazonWebServiceRequest)UpdateItemRequest.builder().build());
    }

    public UpdateItemSpec withPrimaryKey(KeyAttribute ... components) {
        super.withPrimaryKey(components);
        return this;
    }

    public UpdateItemSpec withPrimaryKey(PrimaryKey primaryKey) {
        super.withPrimaryKey(primaryKey);
        return this;
    }

    public UpdateItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue);
        return this;
    }

    public UpdateItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
        return this;
    }

    public List<AttributeUpdate> getAttributeUpdate() {
        return this.attributes;
    }

    public UpdateItemSpec withAttributeUpdate(List<AttributeUpdate> attributeUpdates) {
        this.attributes = attributeUpdates;
        return this;
    }

    public UpdateItemSpec withAttributeUpdate(AttributeUpdate ... attributeUpdates) {
        this.attributes = new ArrayList<AttributeUpdate>(Arrays.asList(attributeUpdates));
        return this;
    }

    public UpdateItemSpec addAttributeUpdate(AttributeUpdate attributeUpdate) {
        if (null == this.attributes) {
            this.attributes = new ArrayList<AttributeUpdate>();
        }
        this.attributes.add(attributeUpdate);
        return this;
    }

    public UpdateItemSpec clearAttributeUpdate() {
        this.attributes = null;
        return this;
    }

    public Collection<Expected> getExpected() {
        return this.expected;
    }

    public UpdateItemSpec withExpected(Expected ... expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        return this.withExpected(Arrays.asList(expected));
    }

    public UpdateItemSpec withExpected(Collection<Expected> expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Expected e : expected) {
            names.add(e.getAttribute());
        }
        if (names.size() != expected.size()) {
            throw new IllegalArgumentException("attribute names must not duplicate in the list of expected");
        }
        this.expected = Collections.unmodifiableCollection(expected);
        return this;
    }

    public String getUpdateExpression() {
        return ((UpdateItemRequest)this.getRequest()).updateExpression();
    }

    public UpdateItemSpec withUpdateExpression(String updateExpression) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().updateExpression(updateExpression).build());
        return this;
    }

    public String getConditionExpression() {
        return ((UpdateItemRequest)this.getRequest()).conditionExpression();
    }

    public UpdateItemSpec withConditionExpression(String conditionExpression) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().conditionExpression(conditionExpression).build());
        return this;
    }

    public Map<String, String> nameMap() {
        return this.nameMap;
    }

    public UpdateItemSpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> valueMap() {
        return this.valueMap;
    }

    public UpdateItemSpec valueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(valueMap));
        return this;
    }

    public String getConditionalOperator() {
        return ((UpdateItemRequest)this.getRequest()).conditionalOperator();
    }

    public String getReturnConsumedCapacity() {
        return ((UpdateItemRequest)this.getRequest()).returnConsumedCapacity();
    }

    public UpdateItemSpec withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().returnConsumedCapacity(returnConsumedCapacity).build());
        return this;
    }

    public UpdateItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().returnConsumedCapacity(returnConsumedCapacity).build());
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return ((UpdateItemRequest)this.getRequest()).returnItemCollectionMetrics();
    }

    public UpdateItemSpec withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().returnItemCollectionMetrics(returnItemCollectionMetrics).build());
        return this;
    }

    public UpdateItemSpec withReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().returnItemCollectionMetrics(returnItemCollectionMetrics).build());
        return this;
    }

    public String getReturnValues() {
        return ((UpdateItemRequest)this.getRequest()).returnValues();
    }

    public UpdateItemSpec withReturnValues(ReturnValue returnValues) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().returnValues(returnValues).build());
        return this;
    }

    public UpdateItemSpec withReturnValues(String returnValues) {
        this.setRequest((AmazonWebServiceRequest)((UpdateItemRequest)this.getRequest()).toBuilder().returnValues(returnValues).build());
        return this;
    }

    @Override
    public UpdateItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }
}

