/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.spec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.services.dynamodb.document.TableKeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.document.spec.AbstractSpec;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;

public class BatchGetItemSpec
extends AbstractSpec<BatchGetItemRequest> {
    private Collection<TableKeysAndAttributes> tableKeyAndAttributes;
    private Map<String, KeysAndAttributes> unprocessedKeys;

    public BatchGetItemSpec() {
        super((AmazonWebServiceRequest)BatchGetItemRequest.builder().build());
    }

    public Collection<TableKeysAndAttributes> getTableKeysAndAttributes() {
        return this.tableKeyAndAttributes;
    }

    public BatchGetItemSpec withTableKeyAndAttributes(TableKeysAndAttributes ... tableKeyAndAttributes) {
        if (tableKeyAndAttributes == null) {
            this.tableKeyAndAttributes = null;
        } else {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (TableKeysAndAttributes e : tableKeyAndAttributes) {
                names.add(e.getTableName());
            }
            if (names.size() != tableKeyAndAttributes.length) {
                throw new IllegalArgumentException("table names must not duplicate in the list of TableKeysAndAttributes");
            }
            this.tableKeyAndAttributes = Arrays.asList(tableKeyAndAttributes);
        }
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((BatchGetItemRequest)((Object)this.getRequest())).returnConsumedCapacity();
    }

    public BatchGetItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity capacity) {
        this.setRequest((AmazonWebServiceRequest)((BatchGetItemRequest)((Object)this.getRequest())).toBuilder().returnConsumedCapacity(capacity).build());
        return this;
    }

    public BatchGetItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.unprocessedKeys;
    }

    public BatchGetItemSpec withUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.unprocessedKeys = Collections.unmodifiableMap(new LinkedHashMap<String, KeysAndAttributes>(unprocessedKeys));
        return this;
    }
}

