/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.jmespath.JmesPathEvaluationVisitor;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.jmespath.JmesPathField;
import software.amazon.awssdk.jmespath.JmesPathSubExpression;
import software.amazon.awssdk.jmespath.JmesPathVisitor;
import software.amazon.awssdk.jmespath.ObjectMapperSingleton;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class TableExists {
    TableExists() {
    }

    static class IsResourceNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeTableResponse> {
        IsResourceNotFoundExceptionMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "ResourceNotFoundException".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsACTIVEMatcher
    extends WaiterAcceptor<DescribeTableResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsACTIVEMatcher() {
        }

        public boolean matches(DescribeTableResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"ACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("Table"), new JmesPathField("TableStatus")});
        }
    }
}

