/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.dynamodb.model.BinarySetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.ListAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.MapAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.NumberSetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.StringSetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeValue
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeValue> {
    private final String s;
    private final String n;
    private final ByteBuffer b;
    private final List<String> ss;
    private final List<String> ns;
    private final List<ByteBuffer> bs;
    private final Map<String, AttributeValue> m;
    private final List<AttributeValue> l;
    private final Boolean bool;
    private final Boolean nul;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
        this.m = builder.m;
        this.l = builder.l;
        this.bool = builder.bool;
        this.nul = builder.nul;
    }

    public String s() {
        return this.s;
    }

    public String n() {
        return this.n;
    }

    public ByteBuffer b() {
        return this.b == null ? null : this.b.asReadOnlyBuffer();
    }

    public List<String> ss() {
        return this.ss;
    }

    public List<String> ns() {
        return this.ns;
    }

    public List<ByteBuffer> bs() {
        return this.bs;
    }

    public Map<String, AttributeValue> m() {
        return this.m;
    }

    public List<AttributeValue> l() {
        return this.l;
    }

    public Boolean bool() {
        return this.bool;
    }

    public Boolean nul() {
        return this.nul;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.s() == null ? 0 : this.s().hashCode());
        hashCode = 31 * hashCode + (this.n() == null ? 0 : this.n().hashCode());
        hashCode = 31 * hashCode + (this.b() == null ? 0 : this.b().hashCode());
        hashCode = 31 * hashCode + (this.ss() == null ? 0 : this.ss().hashCode());
        hashCode = 31 * hashCode + (this.ns() == null ? 0 : this.ns().hashCode());
        hashCode = 31 * hashCode + (this.bs() == null ? 0 : this.bs().hashCode());
        hashCode = 31 * hashCode + (this.m() == null ? 0 : this.m().hashCode());
        hashCode = 31 * hashCode + (this.l() == null ? 0 : this.l().hashCode());
        hashCode = 31 * hashCode + (this.bool() == null ? 0 : this.bool().hashCode());
        hashCode = 31 * hashCode + (this.nul() == null ? 0 : this.nul().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        if (other.s() == null ^ this.s() == null) {
            return false;
        }
        if (other.s() != null && !other.s().equals(this.s())) {
            return false;
        }
        if (other.n() == null ^ this.n() == null) {
            return false;
        }
        if (other.n() != null && !other.n().equals(this.n())) {
            return false;
        }
        if (other.b() == null ^ this.b() == null) {
            return false;
        }
        if (other.b() != null && !other.b().equals(this.b())) {
            return false;
        }
        if (other.ss() == null ^ this.ss() == null) {
            return false;
        }
        if (other.ss() != null && !other.ss().equals(this.ss())) {
            return false;
        }
        if (other.ns() == null ^ this.ns() == null) {
            return false;
        }
        if (other.ns() != null && !other.ns().equals(this.ns())) {
            return false;
        }
        if (other.bs() == null ^ this.bs() == null) {
            return false;
        }
        if (other.bs() != null && !other.bs().equals(this.bs())) {
            return false;
        }
        if (other.m() == null ^ this.m() == null) {
            return false;
        }
        if (other.m() != null && !other.m().equals(this.m())) {
            return false;
        }
        if (other.l() == null ^ this.l() == null) {
            return false;
        }
        if (other.l() != null && !other.l().equals(this.l())) {
            return false;
        }
        if (other.bool() == null ^ this.bool() == null) {
            return false;
        }
        if (other.bool() != null && !other.bool().equals(this.bool())) {
            return false;
        }
        if (other.nul() == null ^ this.nul() == null) {
            return false;
        }
        return other.nul() == null || other.nul().equals(this.nul());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.s() != null) {
            sb.append("S: ").append(this.s()).append(",");
        }
        if (this.n() != null) {
            sb.append("N: ").append(this.n()).append(",");
        }
        if (this.b() != null) {
            sb.append("B: ").append(this.b()).append(",");
        }
        if (this.ss() != null) {
            sb.append("SS: ").append(this.ss()).append(",");
        }
        if (this.ns() != null) {
            sb.append("NS: ").append(this.ns()).append(",");
        }
        if (this.bs() != null) {
            sb.append("BS: ").append(this.bs()).append(",");
        }
        if (this.m() != null) {
            sb.append("M: ").append(this.m()).append(",");
        }
        if (this.l() != null) {
            sb.append("L: ").append(this.l()).append(",");
        }
        if (this.bool() != null) {
            sb.append("BOOL: ").append(this.bool()).append(",");
        }
        if (this.nul() != null) {
            sb.append("NUL: ").append(this.nul()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String s;
        private String n;
        private ByteBuffer b;
        private List<String> ss;
        private List<String> ns;
        private List<ByteBuffer> bs;
        private Map<String, AttributeValue> m;
        private List<AttributeValue> l;
        private Boolean bool;
        private Boolean nul;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.setS(model.s);
            this.setN(model.n);
            this.setB(model.b);
            this.setSS(model.ss);
            this.setNS(model.ns);
            this.setBS(model.bs);
            this.setM(model.m);
            this.setL(model.l);
            this.setBOOL(model.bool);
            this.setNUL(model.nul);
        }

        public final String getS() {
            return this.s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final void setS(String s) {
            this.s = s;
        }

        public final String getN() {
            return this.n;
        }

        @Override
        public final Builder n(String n) {
            this.n = n;
            return this;
        }

        public final void setN(String n) {
            this.n = n;
        }

        public final ByteBuffer getB() {
            return this.b;
        }

        @Override
        public final Builder b(ByteBuffer b) {
            this.b = StandardMemberCopier.copy((ByteBuffer)b);
            return this;
        }

        public final void setB(ByteBuffer b) {
            this.b = StandardMemberCopier.copy((ByteBuffer)b);
        }

        public final Collection<String> getSS() {
            return this.ss;
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String ... ss) {
            this.ss(Arrays.asList(ss));
            return this;
        }

        public final void setSS(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
        }

        @SafeVarargs
        public final void setSS(String ... ss) {
            this.ss(Arrays.asList(ss));
        }

        public final Collection<String> getNS() {
            return this.ns;
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String ... ns) {
            this.ns(Arrays.asList(ns));
            return this;
        }

        public final void setNS(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
        }

        @SafeVarargs
        public final void setNS(String ... ns) {
            this.ns(Arrays.asList(ns));
        }

        public final Collection<ByteBuffer> getBS() {
            return this.bs;
        }

        @Override
        public final Builder bs(Collection<ByteBuffer> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(ByteBuffer ... bs) {
            this.bs(Arrays.asList(bs));
            return this;
        }

        public final void setBS(Collection<ByteBuffer> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
        }

        @SafeVarargs
        public final void setBS(ByteBuffer ... bs) {
            this.bs(Arrays.asList(bs));
        }

        public final Map<String, AttributeValue> getM() {
            return this.m;
        }

        @Override
        public final Builder m(Map<String, AttributeValue> m) {
            this.m = MapAttributeValueCopier.copy(m);
            return this;
        }

        public final void setM(Map<String, AttributeValue> m) {
            this.m = MapAttributeValueCopier.copy(m);
        }

        public final Collection<AttributeValue> getL() {
            return this.l;
        }

        @Override
        public final Builder l(Collection<AttributeValue> l) {
            this.l = ListAttributeValueCopier.copy(l);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(AttributeValue ... l) {
            this.l(Arrays.asList(l));
            return this;
        }

        public final void setL(Collection<AttributeValue> l) {
            this.l = ListAttributeValueCopier.copy(l);
        }

        @SafeVarargs
        public final void setL(AttributeValue ... l) {
            this.l(Arrays.asList(l));
        }

        public final Boolean getBOOL() {
            return this.bool;
        }

        @Override
        public final Builder bool(Boolean bool) {
            this.bool = bool;
            return this;
        }

        public final void setBOOL(Boolean bool) {
            this.bool = bool;
        }

        public final Boolean getNUL() {
            return this.nul;
        }

        @Override
        public final Builder nul(Boolean nul) {
            this.nul = nul;
            return this;
        }

        public final void setNUL(Boolean nul) {
            this.nul = nul;
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeValue> {
        public Builder s(String var1);

        public Builder n(String var1);

        public Builder b(ByteBuffer var1);

        public Builder ss(Collection<String> var1);

        public Builder ss(String ... var1);

        public Builder ns(Collection<String> var1);

        public Builder ns(String ... var1);

        public Builder bs(Collection<ByteBuffer> var1);

        public Builder bs(ByteBuffer ... var1);

        public Builder m(Map<String, AttributeValue> var1);

        public Builder l(Collection<AttributeValue> var1);

        public Builder l(AttributeValue ... var1);

        public Builder bool(Boolean var1);

        public Builder nul(Boolean var1);
    }
}

