/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.MUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class MapUnmarshaller
extends MUnmarshaller {
    private static final MapUnmarshaller INSTANCE = new MapUnmarshaller();
    private final ArgumentUnmarshaller memberUnmarshaller;

    private MapUnmarshaller() {
        this.memberUnmarshaller = null;
    }

    public MapUnmarshaller(ArgumentUnmarshaller memberUnmarshaller) {
        if (memberUnmarshaller == null) {
            throw new NullPointerException("memberUnmarshaller");
        }
        this.memberUnmarshaller = memberUnmarshaller;
    }

    public static MapUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) throws ParseException {
        Map<String, AttributeValue> map = value.m();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeValue> entry : map.entrySet()) {
            this.memberUnmarshaller.typeCheck(entry.getValue(), null);
            result.put(entry.getKey(), this.memberUnmarshaller.unmarshall(entry.getValue()));
        }
        return result;
    }
}

