/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ObjectSetToStringSetMarshaller
implements ArgumentMarshaller.StringSetAttributeMarshaller {
    private static final Logger log = LoggerFactory.getLogger(ObjectSetToStringSetMarshaller.class);
    private static final ObjectSetToStringSetMarshaller INSTANCE = new ObjectSetToStringSetMarshaller();

    private ObjectSetToStringSetMarshaller() {
    }

    public static ObjectSetToStringSetMarshaller instance() {
        return INSTANCE;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        Set set = (Set)obj;
        log.warn("Marshaling a set of non-String objects to a DynamoDB StringSet. You won't be able to read these objects back out of DynamoDB unless you REALLY know what you're doing: it's probably a bug. If you DO know what you're doing feelfree to ignore this warning, but consider using a custom marshaler for this instead.");
        ArrayList<String> strings = new ArrayList<String>(set.size());
        for (Object o : set) {
            strings.add(String.valueOf(o));
        }
        return (AttributeValue)AttributeValue.builder().ss(strings).build();
    }
}

