/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;

public class DynamoDbScanExpression {
    private Map<String, Condition> scanFilter;
    private Map<String, AttributeValue> exclusiveStartKey;
    private Integer limit;
    private Integer totalSegments;
    private Integer segment;
    private String conditionalOperator;
    private String filterExpression;
    private Map<String, String> expressionAttributeNames;
    private Map<String, AttributeValue> expressionAttributeValues;
    private String select;
    private String projectionExpression;
    private String returnConsumedCapacity;
    private String indexName;
    private Boolean consistentRead;

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public DynamoDbScanExpression withIndexName(String indexName) {
        this.setIndexName(indexName);
        return this;
    }

    public Map<String, Condition> scanFilter() {
        return this.scanFilter;
    }

    public void setScanFilter(Map<String, Condition> scanFilter) {
        this.scanFilter = scanFilter;
    }

    public DynamoDbScanExpression withScanFilter(Map<String, Condition> scanFilter) {
        this.setScanFilter(scanFilter);
        return this;
    }

    public void addFilterCondition(String attributeName, Condition condition) {
        if (this.scanFilter == null) {
            this.scanFilter = new HashMap<String, Condition>();
        }
        this.scanFilter.put(attributeName, condition);
    }

    public DynamoDbScanExpression withFilterConditionEntry(String attributeName, Condition condition) {
        if (this.scanFilter == null) {
            this.scanFilter = new HashMap<String, Condition>();
        }
        this.scanFilter.put(attributeName, condition);
        return this;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public DynamoDbScanExpression withExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
        return this;
    }

    public Integer limit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public DynamoDbScanExpression withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getTotalSegments() {
        return this.totalSegments;
    }

    public void setTotalSegments(Integer totalSegments) {
        this.totalSegments = totalSegments;
    }

    public DynamoDbScanExpression withTotalSegments(Integer totalSegments) {
        this.setTotalSegments(totalSegments);
        return this;
    }

    public Integer segment() {
        return this.segment;
    }

    public void setSegment(Integer segment) {
        this.segment = segment;
    }

    public DynamoDbScanExpression withSegment(Integer segment) {
        this.setSegment(segment);
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.setConditionalOperator(conditionalOperator.toString());
    }

    public DynamoDbScanExpression withConditionalOperator(String conditionalOperator) {
        this.setConditionalOperator(conditionalOperator);
        return this;
    }

    public DynamoDbScanExpression withConditionalOperator(ConditionalOperator conditionalOperator) {
        return this.withConditionalOperator(conditionalOperator.toString());
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public DynamoDbScanExpression withFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.expressionAttributeNames = expressionAttributeNames;
    }

    public DynamoDbScanExpression withExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.setExpressionAttributeNames(expressionAttributeNames);
        return this;
    }

    public DynamoDbScanExpression addExpressionAttributeNamesEntry(String key, String value) {
        if (null == this.expressionAttributeNames) {
            this.expressionAttributeNames = new HashMap<String, String>();
        }
        if (this.expressionAttributeNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.expressionAttributeNames.put(key, value);
        return this;
    }

    public DynamoDbScanExpression clearExpressionAttributeNamesEntries() {
        this.expressionAttributeNames = null;
        return this;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.expressionAttributeValues = expressionAttributeValues;
    }

    public DynamoDbScanExpression withExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.setExpressionAttributeValues(expressionAttributeValues);
        return this;
    }

    public DynamoDbScanExpression addExpressionAttributeValuesEntry(String key, AttributeValue value) {
        if (null == this.expressionAttributeValues) {
            this.expressionAttributeValues = new HashMap<String, AttributeValue>();
        }
        if (this.expressionAttributeValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key + ") are provided.");
        }
        this.expressionAttributeValues.put(key, value);
        return this;
    }

    public DynamoDbScanExpression clearExpressionAttributeValuesEntries() {
        this.expressionAttributeValues = null;
        return this;
    }

    public String select() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public void setSelect(Select select) {
        this.select = select.toString();
    }

    public DynamoDbScanExpression withSelect(String select) {
        this.select = select;
        return this;
    }

    public DynamoDbScanExpression withSelect(Select select) {
        this.select = select.toString();
        return this;
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public void setProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
    }

    public DynamoDbScanExpression withProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public DynamoDbScanExpression withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
        return this;
    }

    public DynamoDbScanExpression withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public DynamoDbScanExpression withConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
        return this;
    }
}

