/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.ConversionSchema;
import software.amazon.awssdk.services.dynamodb.datamodeling.ConvertibleType;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMarshalling;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbNativeBoolean;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.ItemConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3ClientCache;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3Link;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardAnnotationMaps;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardBeanProperties;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardModelFactories;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.BooleanSetToNumberSetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.BooleanToBooleanMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.BooleanToNumberMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.ByteArraySetToBinarySetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.ByteArrayToBinaryMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.ByteBufferSetToBinarySetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.ByteBufferToBinaryMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.CalendarSetToStringSetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.CalendarToStringMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.CollectionToListMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.CustomMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.DateSetToStringSetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.DateToStringMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.MapToMapMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.NumberSetToNumberSetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.NumberToNumberMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.ObjectSetToStringSetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.ObjectToMapMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.ObjectToStringMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.S3LinkToStringMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.StringSetToStringSetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.StringToStringMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.marshallers.UuidSetToStringSetMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BigDecimalSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BigDecimalUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BigIntegerSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BigIntegerUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BooleanSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BooleanUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ByteArraySetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ByteArrayUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ByteBufferSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ByteBufferUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ByteSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ByteUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.CalendarSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.CalendarUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.CustomUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.DateSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.DateUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.DoubleSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.DoubleUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.FloatSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.FloatUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.IntegerSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.IntegerUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ListUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.LongSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.LongUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.MapUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.NullableUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ObjectSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ObjectUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.S3LinkUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ShortSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.ShortUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.StringSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.StringUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.UuidSetUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.UuidUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public final class ConversionSchemas {
    public static final ConversionSchema V1 = ConversionSchemas.v1Builder("V1ConversionSchema").build();
    public static final ConversionSchema V2_COMPATIBLE = ConversionSchemas.v2CompatibleBuilder("V2CompatibleConversionSchema").build();
    public static final ConversionSchema V2 = ConversionSchemas.v2Builder("V2ConversionSchema").build();
    static final ConversionSchema DEFAULT = V2_COMPATIBLE;
    private static final Logger log = LoggerFactory.getLogger(ConversionSchemas.class);

    ConversionSchemas() {
        throw new UnsupportedOperationException();
    }

    public static Builder v1Builder(String name) {
        return new Builder(name, V1MarshallerSet.marshallers(), V1MarshallerSet.setMarshallers(), StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
    }

    public static Builder v2CompatibleBuilder(String name) {
        return new Builder(name, V2CompatibleMarshallerSet.marshallers(), V2CompatibleMarshallerSet.setMarshallers(), StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
    }

    public static Builder v2Builder(String name) {
        return new Builder(name, V2MarshallerSet.marshallers(), V2MarshallerSet.setMarshallers(), StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
    }

    private static void addStandardDateMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Date.class, DateToStringMarshaller.instance()));
        list.add(Pair.of(Calendar.class, CalendarToStringMarshaller.instance()));
    }

    private static void addV1BooleanMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanToNumberMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanToNumberMarshaller.instance()));
    }

    private static void addV2BooleanMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanToBooleanMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanToBooleanMarshaller.instance()));
    }

    private static void addStandardNumberMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Number.class, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Byte.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Short.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Integer.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Long.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Float.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Double.TYPE, NumberToNumberMarshaller.instance()));
    }

    private static void addStandardStringMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(String.class, StringToStringMarshaller.instance()));
        list.add(Pair.of(UUID.class, ObjectToStringMarshaller.instance()));
    }

    private static void addStandardBinaryMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(ByteBuffer.class, ByteBufferToBinaryMarshaller.instance()));
        list.add(Pair.of(byte[].class, ByteArrayToBinaryMarshaller.instance()));
    }

    private static void addStandardS3LinkMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(S3Link.class, S3LinkToStringMarshaller.instance()));
    }

    private static void addStandardDateSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Date.class, DateSetToStringSetMarshaller.instance()));
        list.add(Pair.of(Calendar.class, CalendarSetToStringSetMarshaller.instance()));
    }

    private static void addStandardNumberSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Number.class, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Byte.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Short.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Integer.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Long.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Float.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Double.TYPE, NumberSetToNumberSetMarshaller.instance()));
    }

    private static void addStandardStringSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(String.class, StringSetToStringSetMarshaller.instance()));
        list.add(Pair.of(UUID.class, UuidSetToStringSetMarshaller.instance()));
    }

    private static void addStandardBinarySetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(ByteBuffer.class, ByteBufferSetToBinarySetMarshaller.instance()));
        list.add(Pair.of(byte[].class, ByteArraySetToBinarySetMarshaller.instance()));
    }

    private static void addV1BooleanSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanSetToNumberSetMarshaller.instance()));
    }

    private static Class<?> unwrapGenericSetParam(Type setType) {
        if (!(setType instanceof ParameterizedType)) {
            log.warn("Set type " + setType + " is not a ParameterizedType, using default marshaler and unmarshaler!");
            return Object.class;
        }
        ParameterizedType ptype = (ParameterizedType)setType;
        Type[] arguments = ptype.getActualTypeArguments();
        if (arguments.length != 1) {
            log.warn("Set type " + setType + " does not have exactly one type argument, using default marshaler and unmarshaler!");
            return Object.class;
        }
        if (arguments[0].toString().equals("byte[]")) {
            return byte[].class;
        }
        return (Class)arguments[0];
    }

    private static Class<?> resolveClass(Type type) {
        Type localType = type;
        if (localType instanceof ParameterizedType) {
            localType = ((ParameterizedType)type).getRawType();
        }
        if (!(localType instanceof Class)) {
            throw new DynamoDbMappingException("Cannot resolve class for type " + type);
        }
        return (Class)localType;
    }

    private static <T> T find(Class<?> needle, List<Pair<T>> haystack) {
        for (Pair<T> pair : haystack) {
            if (!pair.key.isAssignableFrom(needle)) continue;
            return pair.value;
        }
        return null;
    }

    static class ItemConverterRuleFactory<V>
    implements StandardModelFactories.RuleFactory<V> {
        private final StandardModelFactories.RuleFactory<V> typeConverters;
        private final ItemConverter converter;
        private final boolean customSchema;

        ItemConverterRuleFactory(DynamoDbMapperConfig config, S3Link.Factory s3Links, StandardModelFactories.RuleFactory<V> typeConverters) {
            ConversionSchema.Dependencies depends = new ConversionSchema.Dependencies().with(S3ClientCache.class, s3Links.s3ClientCache());
            ConversionSchema schema = config.getConversionSchema();
            this.customSchema = schema != V1 && schema != V2_COMPATIBLE && schema != V2;
            this.converter = schema.getConverter(depends);
            this.typeConverters = typeConverters;
        }

        @Override
        public StandardModelFactories.Rule<V> getRule(ConvertibleType<V> type) {
            if (this.customSchema && type.typeConverter() == null) {
                return new ItemConverterRule(type);
            }
            return this.typeConverters.getRule(type);
        }

        private final class ItemConverterRule<V>
        implements StandardModelFactories.Rule<V>,
        DynamoDbTypeConverter<AttributeValue, V> {
            private final ConvertibleType<V> type;

            private ItemConverterRule(ConvertibleType<V> type) {
                this.type = type;
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return true;
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, V> newConverter(ConvertibleType<V> type) {
                return this;
            }

            @Override
            public DynamoDbMapperFieldModel.DynamoDbAttributeType getAttributeType() {
                try {
                    return ItemConverterRuleFactory.this.converter.getFieldModel(this.type.getter()).attributeType();
                }
                catch (DynamoDbMappingException dynamoDbMappingException) {
                    return DynamoDbMapperFieldModel.DynamoDbAttributeType.NULL;
                }
            }

            @Override
            public AttributeValue convert(V object) {
                return ItemConverterRuleFactory.this.converter.convert(this.type.getter(), object);
            }

            @Override
            public V unconvert(AttributeValue object) {
                return (V)ItemConverterRuleFactory.this.converter.unconvert(this.type.getter(), this.type.setter(), object);
            }
        }
    }

    static class CachingUnmarshallerSet
    implements UnmarshallerSet {
        private final Map<Method, ArgumentUnmarshaller> cache = new HashMap<Method, ArgumentUnmarshaller>();
        private final Map<Type, ArgumentUnmarshaller> memberCache = new HashMap<Type, ArgumentUnmarshaller>();
        private final UnmarshallerSet wrapped;

        CachingUnmarshallerSet(UnmarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            Map<Method, ArgumentUnmarshaller> map = this.cache;
            synchronized (map) {
                ArgumentUnmarshaller unmarshaler = this.cache.get(getter);
                if (unmarshaler != null) {
                    return unmarshaler;
                }
                unmarshaler = this.wrapped.getUnmarshaller(getter, setter);
                this.cache.put(getter, unmarshaler);
                return unmarshaler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentUnmarshaller memberUnmarshaller(Type memberType) {
            Map<Type, ArgumentUnmarshaller> map = this.memberCache;
            synchronized (map) {
                ArgumentUnmarshaller unmarshaller = this.memberCache.get(memberType);
                if (unmarshaller != null) {
                    return unmarshaller;
                }
                unmarshaller = this.wrapped.memberUnmarshaller(memberType);
                this.memberCache.put(memberType, unmarshaller);
                return unmarshaller;
            }
        }
    }

    static class CachingMarshallerSet
    implements MarshallerSet {
        private final Map<Method, ArgumentMarshaller> cache = new HashMap<Method, ArgumentMarshaller>();
        private final Map<Type, ArgumentMarshaller> memberCache = new HashMap<Type, ArgumentMarshaller>();
        private final MarshallerSet wrapped;

        CachingMarshallerSet(MarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentMarshaller marshaller(Method getter) {
            Map<Method, ArgumentMarshaller> map = this.cache;
            synchronized (map) {
                ArgumentMarshaller marshaler = this.cache.get(getter);
                if (marshaler != null) {
                    return marshaler;
                }
                marshaler = this.wrapped.marshaller(getter);
                this.cache.put(getter, marshaler);
                return marshaler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentMarshaller memberMarshaller(Type memberType) {
            Map<Type, ArgumentMarshaller> map = this.memberCache;
            synchronized (map) {
                ArgumentMarshaller marshaller = this.memberCache.get(memberType);
                if (marshaller != null) {
                    return marshaller;
                }
                marshaller = this.wrapped.memberMarshaller(memberType);
                this.memberCache.put(memberType, marshaller);
                return marshaller;
            }
        }
    }

    static class AnnotationAwareUnmarshallerSet
    implements UnmarshallerSet {
        private final UnmarshallerSet wrapped;

        AnnotationAwareUnmarshallerSet(UnmarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            StandardAnnotationMaps.FieldMap annotations = StandardAnnotationMaps.of(getter, null);
            DynamoDbMarshalling marshalling = annotations.actualOf(DynamoDbMarshalling.class);
            if (marshalling != null) {
                return new CustomUnmarshaller(getter.getReturnType(), marshalling.marshallerClass());
            }
            return this.wrapped.getUnmarshaller(getter, setter);
        }

        @Override
        public ArgumentUnmarshaller memberUnmarshaller(Type c) {
            return this.wrapped.memberUnmarshaller(c);
        }
    }

    static class AnnotationAwareMarshallerSet
    implements MarshallerSet {
        private final MarshallerSet wrapped;

        AnnotationAwareMarshallerSet(MarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ArgumentMarshaller marshaller(Method getter) {
            StandardAnnotationMaps.FieldMap annotations = StandardAnnotationMaps.of(getter, null);
            DynamoDbMarshalling marshalling = annotations.actualOf(DynamoDbMarshalling.class);
            if (marshalling != null) {
                return new CustomMarshaller(marshalling.marshallerClass());
            }
            if (annotations.actualOf(DynamoDbNativeBoolean.class) != null) {
                return BooleanToBooleanMarshaller.instance();
            }
            return this.wrapped.marshaller(getter);
        }

        @Override
        public ArgumentMarshaller memberMarshaller(Type memberType) {
            return this.wrapped.memberMarshaller(memberType);
        }
    }

    private static class Pair<T> {
        public final Class<?> key;
        public final T value;

        private Pair(Class<?> key, T value) {
            this.key = key;
            this.value = value;
        }

        public static Pair<ArgumentMarshaller> of(Class<?> key, ArgumentMarshaller value) {
            return new Pair<ArgumentMarshaller>(key, value);
        }

        public static Pair<ArgumentUnmarshaller> of(Class<?> key, ArgumentUnmarshaller value) {
            return new Pair<ArgumentUnmarshaller>(key, value);
        }
    }

    static class StandardUnmarshallerSet
    implements UnmarshallerSet {
        private final List<Pair<ArgumentUnmarshaller>> unmarshallers;
        private final List<Pair<ArgumentUnmarshaller>> setUnmarshallers;

        StandardUnmarshallerSet() {
            this(StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
        }

        StandardUnmarshallerSet(List<Pair<ArgumentUnmarshaller>> unmarshallers, List<Pair<ArgumentUnmarshaller>> setUnmarshallers) {
            this.unmarshallers = unmarshallers;
            this.setUnmarshallers = setUnmarshallers;
        }

        private static List<Pair<ArgumentUnmarshaller>> unmarshallers() {
            ArrayList<Pair<ArgumentUnmarshaller>> list = new ArrayList<Pair<ArgumentUnmarshaller>>();
            list.add(Pair.of(Double.TYPE, DoubleUnmarshaller.instance()));
            list.add(Pair.of(Double.class, DoubleUnmarshaller.instance()));
            list.add(Pair.of(BigDecimal.class, BigDecimalUnmarshaller.instance()));
            list.add(Pair.of(BigInteger.class, BigIntegerUnmarshaller.instance()));
            list.add(Pair.of(Integer.TYPE, IntegerUnmarshaller.instance()));
            list.add(Pair.of(Integer.class, IntegerUnmarshaller.instance()));
            list.add(Pair.of(Float.TYPE, FloatUnmarshaller.instance()));
            list.add(Pair.of(Float.class, FloatUnmarshaller.instance()));
            list.add(Pair.of(Byte.TYPE, ByteUnmarshaller.instance()));
            list.add(Pair.of(Byte.class, ByteUnmarshaller.instance()));
            list.add(Pair.of(Long.TYPE, LongUnmarshaller.instance()));
            list.add(Pair.of(Long.class, LongUnmarshaller.instance()));
            list.add(Pair.of(Short.TYPE, ShortUnmarshaller.instance()));
            list.add(Pair.of(Short.class, ShortUnmarshaller.instance()));
            list.add(Pair.of(Boolean.TYPE, BooleanUnmarshaller.instance()));
            list.add(Pair.of(Boolean.class, BooleanUnmarshaller.instance()));
            list.add(Pair.of(Date.class, DateUnmarshaller.instance()));
            list.add(Pair.of(Calendar.class, CalendarUnmarshaller.instance()));
            list.add(Pair.of(ByteBuffer.class, ByteBufferUnmarshaller.instance()));
            list.add(Pair.of(byte[].class, ByteArrayUnmarshaller.instance()));
            list.add(Pair.of(S3Link.class, S3LinkUnmarshaller.instance()));
            list.add(Pair.of(UUID.class, UuidUnmarshaller.instance()));
            list.add(Pair.of(String.class, StringUnmarshaller.instance()));
            list.add(Pair.of(List.class, ListUnmarshaller.instance()));
            list.add(Pair.of(Map.class, MapUnmarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectUnmarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentUnmarshaller>> setUnmarshallers() {
            ArrayList<Pair<ArgumentUnmarshaller>> list = new ArrayList<Pair<ArgumentUnmarshaller>>();
            list.add(Pair.of(Double.TYPE, DoubleSetUnmarshaller.instance()));
            list.add(Pair.of(Double.class, DoubleSetUnmarshaller.instance()));
            list.add(Pair.of(BigDecimal.class, BigDecimalSetUnmarshaller.instance()));
            list.add(Pair.of(BigInteger.class, BigIntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Integer.TYPE, IntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Integer.class, IntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Float.TYPE, FloatSetUnmarshaller.instance()));
            list.add(Pair.of(Float.class, FloatSetUnmarshaller.instance()));
            list.add(Pair.of(Byte.TYPE, ByteSetUnmarshaller.instance()));
            list.add(Pair.of(Byte.class, ByteSetUnmarshaller.instance()));
            list.add(Pair.of(Long.TYPE, LongSetUnmarshaller.instance()));
            list.add(Pair.of(Long.class, LongSetUnmarshaller.instance()));
            list.add(Pair.of(Short.TYPE, ShortSetUnmarshaller.instance()));
            list.add(Pair.of(Short.class, ShortSetUnmarshaller.instance()));
            list.add(Pair.of(Boolean.TYPE, BooleanSetUnmarshaller.instance()));
            list.add(Pair.of(Boolean.class, BooleanSetUnmarshaller.instance()));
            list.add(Pair.of(Date.class, DateSetUnmarshaller.instance()));
            list.add(Pair.of(Calendar.class, CalendarSetUnmarshaller.instance()));
            list.add(Pair.of(ByteBuffer.class, ByteBufferSetUnmarshaller.instance()));
            list.add(Pair.of(byte[].class, ByteArraySetUnmarshaller.instance()));
            list.add(Pair.of(UUID.class, UuidSetUnmarshaller.instance()));
            list.add(Pair.of(String.class, StringSetUnmarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectSetUnmarshaller.instance()));
            return list;
        }

        @Override
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            if (setter.getParameterTypes().length != 1) {
                throw new DynamoDbMappingException("Expected exactly one agument to " + setter);
            }
            Class paramType = setter.getParameterTypes()[0];
            if (Set.class.isAssignableFrom(paramType)) {
                paramType = ConversionSchemas.unwrapGenericSetParam(setter.getGenericParameterTypes()[0]);
                return this.set(setter, paramType);
            }
            return this.scalar(setter, paramType);
        }

        @Override
        public ArgumentUnmarshaller memberUnmarshaller(Type memberType) {
            Class clazz = ConversionSchemas.resolveClass(memberType);
            if (Set.class.isAssignableFrom(clazz)) {
                Class setMemberType = ConversionSchemas.unwrapGenericSetParam(memberType);
                return this.set(null, setMemberType);
            }
            return this.scalar(null, clazz);
        }

        private ArgumentUnmarshaller set(Method setter, Class<?> paramType) {
            ArgumentUnmarshaller unmarshaller = (ArgumentUnmarshaller)ConversionSchemas.find(paramType, this.setUnmarshallers);
            String className = "?";
            String methodName = "?";
            if (setter != null) {
                className = setter.getDeclaringClass().toString();
                methodName = setter.getName();
            }
            if (unmarshaller == null) {
                throw new DynamoDbMappingException("Cannot unmarshall to parameter type Set<" + paramType + "> of method " + className + "." + methodName + " without a custom unmarshaler.");
            }
            return unmarshaller;
        }

        private ArgumentUnmarshaller scalar(Method setter, Class<?> type) {
            ArgumentUnmarshaller unmarshaller = (ArgumentUnmarshaller)ConversionSchemas.find(type, this.unmarshallers);
            String className = "?";
            String methodName = "?";
            if (setter != null) {
                className = setter.getDeclaringClass().toString();
                methodName = setter.getName();
            }
            if (unmarshaller == null) {
                throw new DynamoDbMappingException("Cannot unmarshall to parameter type " + type + "of method " + className + "." + methodName + " without a custom unmarshaler.");
            }
            return unmarshaller;
        }
    }

    private static class AbstractMarshallerSet
    implements MarshallerSet {
        private final List<Pair<ArgumentMarshaller>> marshallers;
        private final List<Pair<ArgumentMarshaller>> setMarshallers;

        AbstractMarshallerSet(List<Pair<ArgumentMarshaller>> marshallers, List<Pair<ArgumentMarshaller>> setMarshallers) {
            this.marshallers = marshallers;
            this.setMarshallers = setMarshallers;
        }

        @Override
        public ArgumentMarshaller marshaller(Method getter) {
            Class<?> returnType = getter.getReturnType();
            if (Set.class.isAssignableFrom(returnType)) {
                Class memberType = ConversionSchemas.unwrapGenericSetParam(getter.getGenericReturnType());
                return this.set(getter, memberType);
            }
            return this.scalar(getter, returnType);
        }

        @Override
        public ArgumentMarshaller memberMarshaller(Type memberType) {
            Class clazz = ConversionSchemas.resolveClass(memberType);
            if (Set.class.isAssignableFrom(clazz)) {
                Class setMemberType = ConversionSchemas.unwrapGenericSetParam(memberType);
                return this.set(null, setMemberType);
            }
            return this.scalar(null, clazz);
        }

        private ArgumentMarshaller scalar(Method getter, Class<?> type) {
            ArgumentMarshaller marshaller = (ArgumentMarshaller)ConversionSchemas.find(type, this.marshallers);
            if (marshaller == null) {
                String className = "?";
                String methodName = "?";
                if (getter != null) {
                    className = getter.getDeclaringClass().toString();
                    methodName = getter.getName();
                }
                throw new DynamoDbMappingException("Cannot marshall return type " + type + " of method " + className + "." + methodName + " without a custom marshaler.");
            }
            return marshaller;
        }

        private ArgumentMarshaller set(Method getter, Class<?> memberType) {
            ArgumentMarshaller marshaller = (ArgumentMarshaller)ConversionSchemas.find(memberType, this.setMarshallers);
            if (marshaller == null) {
                String className = "?";
                String methodName = "?";
                if (getter != null) {
                    className = getter.getDeclaringClass().toString();
                    methodName = getter.getName();
                }
                throw new DynamoDbMappingException("Cannot marshall return type Set<" + memberType + "> of method " + className + "." + methodName + " without a custom marshaller.");
            }
            return marshaller;
        }
    }

    static final class V1MarshallerSet {
        V1MarshallerSet() {
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV1BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addV1BooleanSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, ObjectSetToStringSetMarshaller.instance()));
            return list;
        }
    }

    static final class V2CompatibleMarshallerSet {
        V2CompatibleMarshallerSet() {
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV1BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            list.add(Pair.of(List.class, CollectionToListMarshaller.instance()));
            list.add(Pair.of(Map.class, MapToMapMarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectToMapMarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addV1BooleanSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, ObjectSetToStringSetMarshaller.instance()));
            return list;
        }
    }

    static final class V2MarshallerSet {
        V2MarshallerSet() {
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV2BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            list.add(Pair.of(List.class, CollectionToListMarshaller.instance()));
            list.add(Pair.of(Map.class, MapToMapMarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectToMapMarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, CollectionToListMarshaller.instance()));
            return list;
        }
    }

    static class StandardItemConverter
    implements ItemConverter {
        private final MarshallerSet marshallerSet;
        private final UnmarshallerSet unmarshallerSet;
        private final S3ClientCache s3cc;

        StandardItemConverter(MarshallerSet marshallerSet, UnmarshallerSet unmarshallerSet, S3ClientCache s3cc) {
            this.marshallerSet = marshallerSet;
            this.unmarshallerSet = unmarshallerSet;
            this.s3cc = s3cc;
        }

        private static Object unmarshall(ArgumentUnmarshaller unmarshaller, Method setter, AttributeValue value) {
            unmarshaller.typeCheck(value, setter);
            try {
                return unmarshaller.unmarshall(value);
            }
            catch (IllegalArgumentException e) {
                throw new DynamoDbMappingException("Couldn't unmarshall value " + value + " for " + setter, e);
            }
            catch (ParseException e) {
                throw new DynamoDbMappingException("Error attempting to parse date string " + value + " for " + setter, e);
            }
        }

        private static <T> T createObject(Class<T> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new DynamoDbMappingException("Failed to instantiate new instance of class", e);
            }
            catch (IllegalAccessException e) {
                throw new DynamoDbMappingException("Failed to instantiate new instance of class", e);
            }
        }

        @Override
        public DynamoDbMapperFieldModel getFieldModel(Method getter) {
            DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType;
            ArgumentMarshaller marshaller = this.marshaller(getter);
            if (marshaller instanceof ArgumentMarshaller.StringAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.S;
            } else if (marshaller instanceof ArgumentMarshaller.NumberAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.N;
            } else if (marshaller instanceof ArgumentMarshaller.BinaryAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.B;
            } else if (marshaller instanceof ArgumentMarshaller.StringSetAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.SS;
            } else if (marshaller instanceof ArgumentMarshaller.NumberSetAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.NS;
            } else if (marshaller instanceof ArgumentMarshaller.BinarySetAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.BS;
            } else if (marshaller instanceof ArgumentMarshaller.BooleanAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.BOOL;
            } else if (marshaller instanceof ArgumentMarshaller.ListAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.L;
            } else if (marshaller instanceof ArgumentMarshaller.MapAttributeMarshaller) {
                attributeType = DynamoDbMapperFieldModel.DynamoDbAttributeType.M;
            } else {
                throw new DynamoDbMappingException("Unrecognized marshaller type for " + getter + ": " + marshaller);
            }
            StandardAnnotationMaps.FieldMap annotations = StandardAnnotationMaps.of(getter, null);
            DynamoDbMapperFieldModel.Builder builder = new DynamoDbMapperFieldModel.Builder(Void.TYPE, annotations);
            builder.with(attributeType);
            return builder.build();
        }

        @Override
        public AttributeValue convert(Method getter, Object object) {
            if (object == null) {
                return null;
            }
            ArgumentMarshaller marshaller = this.marshaller(getter);
            return marshaller.marshall(object);
        }

        @Override
        public Map<String, AttributeValue> convert(Object object) {
            if (object == null) {
                return null;
            }
            Class<?> clazz = object.getClass();
            HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
            for (StandardBeanProperties.Bean<?, Object> bean : StandardBeanProperties.of(clazz).map().values()) {
                AttributeValue value;
                Object getterResult = bean.reflect().get(object);
                if (getterResult == null || (value = this.convert(bean.type().getter(), getterResult)) == null) continue;
                result.put(bean.properties().attributeName(), value);
            }
            return result;
        }

        private ArgumentMarshaller marshaller(Method getter) {
            ArgumentMarshaller marshaller = this.marshallerSet.marshaller(getter);
            marshaller = this.augment(getter.getGenericReturnType(), marshaller);
            return marshaller;
        }

        private ArgumentMarshaller memberMarshaller(Type type) {
            ArgumentMarshaller marshaller = this.marshallerSet.memberMarshaller(type);
            marshaller = this.augment(type, marshaller);
            return marshaller;
        }

        private ArgumentMarshaller augment(Type type, ArgumentMarshaller marshaller) {
            if (marshaller instanceof CollectionToListMarshaller) {
                return this.getCollectionToListMarshaller(type);
            }
            if (marshaller instanceof MapToMapMarshaller) {
                return this.mapToMapMarshaller(type);
            }
            if (marshaller instanceof ObjectToMapMarshaller) {
                return this.getObjectToMapMarshaller(type);
            }
            return marshaller;
        }

        private ArgumentMarshaller getCollectionToListMarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Collection type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Collection type " + type + "; unexpected number of type arguments.");
            }
            ArgumentMarshaller memberMarshaller = this.memberMarshaller(args[0]);
            return new CollectionToListMarshaller(memberMarshaller);
        }

        private ArgumentMarshaller mapToMapMarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Map type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 2) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Map type " + type + "; unexpected number of type arguments.");
            }
            if (args[0] != String.class) {
                throw new DynamoDbMappingException("Only Map<String, ?> is supported.");
            }
            ArgumentMarshaller memberMarshaller = this.memberMarshaller(args[1]);
            return new MapToMapMarshaller(memberMarshaller);
        }

        private ArgumentMarshaller getObjectToMapMarshaller(Type type) {
            Type localType = type;
            if (localType instanceof ParameterizedType) {
                localType = ((ParameterizedType)localType).getRawType();
            }
            if (!(localType instanceof Class)) {
                throw new DynamoDbMappingException("Cannot convert " + type + " to a class");
            }
            Class clazz = (Class)localType;
            if (StandardAnnotationMaps.of(clazz).attributeType() != DynamoDbMapperFieldModel.DynamoDbAttributeType.M) {
                throw new DynamoDbMappingException("Cannot marshall type " + type + " without a custom marshaler or @DynamoDBDocument annotation.");
            }
            return new ObjectToMapMarshaller(this);
        }

        @Override
        public Object unconvert(Method getter, Method setter, AttributeValue value) {
            ArgumentUnmarshaller unmarshaller = this.getUnmarshaller(getter, setter);
            return StandardItemConverter.unmarshall(unmarshaller, setter, value);
        }

        @Override
        public <T> T unconvert(Class<T> clazz, Map<String, AttributeValue> value) {
            T result = StandardItemConverter.createObject(clazz);
            if (value == null || value.isEmpty()) {
                return result;
            }
            for (StandardBeanProperties.Bean<T, Object> bean : StandardBeanProperties.of(clazz).map().values()) {
                AttributeValue av = value.get(bean.properties().attributeName());
                if (av == null) continue;
                ArgumentUnmarshaller unmarshaller = this.getUnmarshaller(bean.type().getter(), bean.type().setter());
                Object unmarshalled = StandardItemConverter.unmarshall(unmarshaller, bean.type().setter(), av);
                bean.reflect().set(result, unmarshalled);
            }
            return result;
        }

        private ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            ArgumentUnmarshaller unmarshaller = this.unmarshallerSet.getUnmarshaller(getter, setter);
            unmarshaller = this.augment(setter.getGenericParameterTypes()[0], unmarshaller);
            return new NullableUnmarshaller(unmarshaller);
        }

        private ArgumentUnmarshaller memberUnmarshaller(Type type) {
            ArgumentUnmarshaller unmarshaller = this.unmarshallerSet.memberUnmarshaller(type);
            unmarshaller = this.augment(type, unmarshaller);
            return new NullableUnmarshaller(unmarshaller);
        }

        private ArgumentUnmarshaller augment(Type type, ArgumentUnmarshaller unmarshaller) {
            if (unmarshaller instanceof S3LinkUnmarshaller) {
                return new S3LinkUnmarshaller(this.s3cc);
            }
            if (unmarshaller instanceof ObjectSetUnmarshaller) {
                return this.getObjectSetUnmarshaller(type);
            }
            if (unmarshaller instanceof ListUnmarshaller) {
                return this.listUnmarshaller(type);
            }
            if (unmarshaller instanceof MapUnmarshaller) {
                return this.mapUnmarshaller(type);
            }
            if (unmarshaller instanceof ObjectUnmarshaller) {
                return this.getObjectUnmarshaller(type);
            }
            return unmarshaller;
        }

        private ArgumentUnmarshaller getObjectSetUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Set type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Set type " + type + "; unexpected number of type arguments.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.memberUnmarshaller(args[0]);
            return new ObjectSetUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller listUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the List type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the List type " + type + "; unexpected number of type arguments.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.memberUnmarshaller(args[0]);
            return new ListUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller mapUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Map type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 2) {
                throw new DynamoDbMappingException("Cannot tell what type of objects belong in the Map type " + type + "; unexpected number of type arguments.");
            }
            if (args[0] != String.class) {
                throw new DynamoDbMappingException("Only Map<String, ?> is supported.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.memberUnmarshaller(args[1]);
            return new MapUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller getObjectUnmarshaller(Type type) {
            Type localType = type;
            if (localType instanceof ParameterizedType) {
                localType = ((ParameterizedType)type).getRawType();
            }
            if (!(localType instanceof Class)) {
                throw new DynamoDbMappingException("Cannot convert " + type + " to a class");
            }
            Class clazz = (Class)localType;
            if (StandardAnnotationMaps.of(clazz).attributeType() != DynamoDbMapperFieldModel.DynamoDbAttributeType.M) {
                throw new DynamoDbMappingException("Cannot unmarshall to type " + type + " without a custom marshaler or @DynamoDBDocument annotation.");
            }
            return new ObjectUnmarshaller(this, clazz);
        }
    }

    static class StandardConversionSchema
    implements ConversionSchema {
        private final String name;
        private final MarshallerSet marshallers;
        private final UnmarshallerSet unmarshallers;

        StandardConversionSchema(String name, MarshallerSet marshallers, UnmarshallerSet unmarshallers) {
            this.name = name;
            this.marshallers = new CachingMarshallerSet(new AnnotationAwareMarshallerSet(marshallers));
            this.unmarshallers = new CachingUnmarshallerSet(new AnnotationAwareUnmarshallerSet(unmarshallers));
        }

        @Override
        public ItemConverter getConverter(ConversionSchema.Dependencies dependencies) {
            S3ClientCache s3cc = dependencies.get(S3ClientCache.class);
            return new StandardItemConverter(this.marshallers, this.unmarshallers, s3cc);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Builder {
        private final String name;
        private final List<Pair<ArgumentMarshaller>> marshallers;
        private final List<Pair<ArgumentMarshaller>> setMarshallers;
        private final List<Pair<ArgumentUnmarshaller>> unmarshallers;
        private final List<Pair<ArgumentUnmarshaller>> setUnmarshallers;

        Builder(String name, List<Pair<ArgumentMarshaller>> marshallers, List<Pair<ArgumentMarshaller>> setMarshallers, List<Pair<ArgumentUnmarshaller>> unmarshallers, List<Pair<ArgumentUnmarshaller>> setUnmarshallers) {
            this.name = name;
            this.marshallers = marshallers;
            this.setMarshallers = setMarshallers;
            this.unmarshallers = unmarshallers;
            this.setUnmarshallers = setUnmarshallers;
        }

        public Builder addFirstType(Class<?> clazz, ArgumentMarshaller marshaller, ArgumentUnmarshaller unmarshaller) {
            this.marshallers.add(0, Pair.of(clazz, marshaller));
            this.unmarshallers.add(0, Pair.of(clazz, unmarshaller));
            return this;
        }

        public Builder addFirstSetType(Class<?> clazz, ArgumentMarshaller marshaller, ArgumentUnmarshaller unmarshaller) {
            this.setMarshallers.add(0, Pair.of(clazz, marshaller));
            this.setUnmarshallers.add(0, Pair.of(clazz, unmarshaller));
            return this;
        }

        public ConversionSchema build() {
            return new StandardConversionSchema(this.name, new AbstractMarshallerSet(this.marshallers, this.setMarshallers), new StandardUnmarshallerSet(this.unmarshallers, this.setUnmarshallers));
        }
    }

    static interface UnmarshallerSet {
        public ArgumentUnmarshaller getUnmarshaller(Method var1, Method var2);

        public ArgumentUnmarshaller memberUnmarshaller(Type var1);
    }

    static interface MarshallerSet {
        public ArgumentMarshaller marshaller(Method var1);

        public ArgumentMarshaller memberMarshaller(Type var1);
    }
}

